/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth;

import java.util.Optional;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.AbstractAuthenticationProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthProvider.class);
    private static final String AUTH_TYPE = "basic";

    @Override
    protected void configureAuthentication(HttpAsyncClientBuilder httpClientBuilder, ReadonlyConfig config) {
        Optional username = config.getOptional(ElasticsearchBaseOptions.USERNAME);
        Optional password = config.getOptional(ElasticsearchBaseOptions.PASSWORD);
        if (username.isPresent() && password.isPresent()) {
            log.debug("Configuring basic authentication for user: {}", username.get());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials((String)username.get(), (String)password.get()));
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            log.info("Basic authentication configured successfully for user: {}", username.get());
        } else {
            log.debug("No username/password provided, skipping basic authentication configuration");
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public void validate(ReadonlyConfig config) {
        Optional username = config.getOptional(ElasticsearchBaseOptions.USERNAME);
        Optional password = config.getOptional(ElasticsearchBaseOptions.PASSWORD);
        if (username.isPresent() && !password.isPresent()) {
            throw new IllegalArgumentException("Password is required when username is provided for basic authentication");
        }
        if (!username.isPresent() && password.isPresent()) {
            throw new IllegalArgumentException("Username is required when password is provided for basic authentication");
        }
        if (username.isPresent()) {
            String usernameValue = (String)username.get();
            if (usernameValue == null || usernameValue.trim().isEmpty()) {
                throw new IllegalArgumentException("Username cannot be null or empty");
            }
            String passwordValue = (String)password.get();
            if (passwordValue == null || passwordValue.trim().isEmpty()) {
                throw new IllegalArgumentException("Password cannot be null or empty");
            }
            log.debug("Basic authentication configuration validated for user: {}", (Object)usernameValue);
        } else {
            log.debug("No basic authentication credentials provided - authentication will be skipped");
        }
    }
}

