/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.shaded.okio;

import com.aliyun.datahub.shaded.okio.SegmentPool;
import javax.annotation.Nullable;

final class Segment {
    static final int SIZE = 8192;
    static final int SHARE_MINIMUM = 1024;
    final byte[] data;
    int pos;
    int limit;
    boolean shared;
    boolean owner;
    Segment next;
    Segment prev;

    Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    Segment(byte[] data, int pos, int limit, boolean shared, boolean owner) {
        this.data = data;
        this.pos = pos;
        this.limit = limit;
        this.shared = shared;
        this.owner = owner;
    }

    final Segment sharedCopy() {
        this.shared = true;
        return new Segment(this.data, this.pos, this.limit, true, false);
    }

    final Segment unsharedCopy() {
        return new Segment((byte[])this.data.clone(), this.pos, this.limit, false, true);
    }

    @Nullable
    public final Segment pop() {
        Segment result = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return result;
    }

    public final Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int byteCount) {
        Segment prefix;
        if (byteCount <= 0 || byteCount > this.limit - this.pos) {
            throw new IllegalArgumentException();
        }
        if (byteCount >= 1024) {
            prefix = this.sharedCopy();
        } else {
            prefix = SegmentPool.take();
            System.arraycopy(this.data, this.pos, prefix.data, 0, byteCount);
        }
        prefix.limit = prefix.pos + byteCount;
        this.pos += byteCount;
        this.prev.push(prefix);
        return prefix;
    }

    public final void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (!this.prev.owner) {
            return;
        }
        int byteCount = this.limit - this.pos;
        int availableByteCount = 8192 - this.prev.limit + (this.prev.shared ? 0 : this.prev.pos);
        if (byteCount > availableByteCount) {
            return;
        }
        this.writeTo(this.prev, byteCount);
        this.pop();
        SegmentPool.recycle(this);
    }

    public final void writeTo(Segment sink2, int byteCount) {
        if (!sink2.owner) {
            throw new IllegalArgumentException();
        }
        if (sink2.limit + byteCount > 8192) {
            if (sink2.shared) {
                throw new IllegalArgumentException();
            }
            if (sink2.limit + byteCount - sink2.pos > 8192) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(sink2.data, sink2.pos, sink2.data, 0, sink2.limit - sink2.pos);
            sink2.limit -= sink2.pos;
            sink2.pos = 0;
        }
        System.arraycopy(this.data, this.pos, sink2.data, sink2.limit, byteCount);
        sink2.limit += byteCount;
        this.pos += byteCount;
    }
}

