/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.util.JsonUtils;
import com.aliyun.datahub.shaded.org.apache.commons.lang3.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

public class RecordSchemaSerializer
extends JsonSerializer<RecordSchema> {
    @Override
    public void serialize(RecordSchema recordSchema, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        List<Field> fields = recordSchema.getFields();
        StringWriter writer = new StringWriter();
        JsonGenerator tempGenerator = JsonUtils.getMAPPER().getFactory().createGenerator(writer);
        tempGenerator.writeStartObject();
        tempGenerator.writeArrayFieldStart("fields");
        for (Field field : fields) {
            tempGenerator.writeStartObject();
            tempGenerator.writeStringField("name", field.getName());
            tempGenerator.writeStringField("type", field.getType().name());
            if (!field.isAllowNull()) {
                tempGenerator.writeBooleanField("notnull", !field.isAllowNull());
            }
            if (StringUtils.isNotBlank(field.getComment())) {
                tempGenerator.writeStringField("comment", field.getComment());
            }
            tempGenerator.writeEndObject();
        }
        tempGenerator.writeEndArray();
        tempGenerator.writeEndObject();
        tempGenerator.close();
        String shemaStr = writer.toString();
        jsonGenerator.writeString(shemaStr);
    }
}

