/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter;

import com.aliyun.datahub.client.util.CrcUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MessageInputStream
extends DataInputStream {
    public MessageInputStream(InputStream in, boolean enablePbCrc) throws IOException {
        super(new FramedBuffer(in, enablePbCrc));
    }

    private static class FramedBuffer
    extends InputStream {
        private ByteArrayInputStream innerBuffer;

        public FramedBuffer(InputStream inputStream2, boolean enablePbCrc) throws IOException {
            int compute;
            int len;
            int pos;
            int len2;
            DataInputStream dis = new DataInputStream(inputStream2);
            byte[] buffer = new byte[4];
            for (pos = 0; pos < 4; pos += len2) {
                len2 = inputStream2.read(buffer, pos, 4 - pos);
                if (len2 != -1) continue;
                throw new IOException("Read pb fail");
            }
            if (pos != 4 || !Arrays.equals(buffer, "DHUB".getBytes())) {
                throw new IOException("Pb magic is invalid. magic" + new String(buffer));
            }
            int crc32 = dis.readInt();
            int dataLength = dis.readInt();
            buffer = new byte[dataLength];
            for (pos = 0; pos < dataLength; pos += len) {
                len = dis.read(buffer, pos, dataLength - pos);
                if (len != -1) continue;
                throw new IOException("Read pb fail");
            }
            if (enablePbCrc && crc32 != 0 && crc32 != (compute = CrcUtils.getCrc32(buffer))) {
                throw new IOException("Check Crc fail. read:" + crc32 + ", compute:" + compute);
            }
            this.innerBuffer = new ByteArrayInputStream(buffer);
        }

        @Override
        public synchronized int read() {
            return this.innerBuffer.read();
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            return this.innerBuffer.read(b, off, len);
        }

        @Override
        public synchronized long skip(long n) {
            return this.innerBuffer.skip(n);
        }

        @Override
        public synchronized int available() {
            return this.innerBuffer.available();
        }

        @Override
        public boolean markSupported() {
            return this.innerBuffer.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) {
            this.innerBuffer.mark(readAheadLimit);
        }

        @Override
        public synchronized void reset() {
            this.innerBuffer.reset();
        }
    }
}

