/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.common;

import com.aliyun.datahub.client.http.common.HttpRequest;
import com.aliyun.datahub.client.model.BaseResult;
import com.aliyun.datahub.client.util.JsonUtils;
import com.aliyun.datahub.shaded.okhttp3.Response;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private int httpStatus;
    private Map<String, String> headers = new HashMap<String, String>();
    private String bodyStr;

    public HttpResponse(HttpRequest request, Response response, String bodyStr) {
        this.httpStatus = response.code();
        this.bodyStr = bodyStr;
        for (String name : response.headers().names()) {
            this.headers.put(name.toLowerCase(), response.header(name));
        }
    }

    public <T> T getEntity(Class<T> returnType) {
        T result = null;
        if (returnType != null) {
            if (String.class.equals(returnType)) {
                result = returnType.cast(this.bodyStr);
            } else if (this.isMediaSupport() && (result = (T)JsonUtils.fromJson(this.bodyStr, returnType)) != null && BaseResult.class.isAssignableFrom(returnType)) {
                String requestId = this.headers.get("x-datahub-request-id");
                ((BaseResult)result).setRequestId(requestId);
            }
        }
        return result;
    }

    public <T> T getEntity(TypeReference returnType) {
        T result = null;
        if (returnType != null && this.isMediaSupport()) {
            result = JsonUtils.fromJson(this.bodyStr, returnType);
        }
        return result;
    }

    private boolean isMediaSupport() {
        String mediaType = this.headers.get("Content-Type".toLowerCase());
        return mediaType != null && (mediaType.contains("application/json") || mediaType.contains("application/x-protobuf"));
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public String getBodyStr() {
        return this.bodyStr;
    }
}

