/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSourceOptions;

public class DatabendSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private Boolean ssl;
    private String username;
    private String password;
    private String database;
    private String table;
    private Boolean autoCommit;
    private Integer maxRetries;
    private Map<String, String> jdbcConfig;
    private String query;
    private String sql;
    private Integer fetchSize;
    private Properties properties;

    public static DatabendSourceConfig of(ReadonlyConfig config) {
        DatabendSourceConfig sourceConfig = new DatabendSourceConfig();
        sourceConfig.setUrl((String)config.get(DatabendOptions.URL));
        sourceConfig.setSsl((Boolean)config.get(DatabendOptions.SSL));
        sourceConfig.setUsername((String)config.get(DatabendOptions.USERNAME));
        sourceConfig.setPassword((String)config.get(DatabendOptions.PASSWORD));
        sourceConfig.setDatabase((String)config.get(DatabendOptions.DATABASE));
        sourceConfig.setTable((String)config.get(DatabendOptions.TABLE));
        sourceConfig.setAutoCommit((Boolean)config.get(DatabendOptions.AUTO_COMMIT));
        sourceConfig.setMaxRetries((Integer)config.get(DatabendOptions.MAX_RETRIES));
        sourceConfig.setJdbcConfig((Map)config.get(DatabendOptions.JDBC_CONFIG));
        sourceConfig.setQuery(config.getOptional(DatabendOptions.QUERY).orElse(null));
        sourceConfig.setSql(config.getOptional(DatabendSourceOptions.SQL).orElse(null));
        sourceConfig.setFetchSize((Integer)config.get(DatabendOptions.FETCH_SIZE));
        Properties properties = new Properties();
        if (sourceConfig.getJdbcConfig() != null) {
            sourceConfig.getJdbcConfig().forEach(properties::setProperty);
        }
        if (!properties.containsKey("user")) {
            properties.setProperty("user", sourceConfig.getUsername());
        }
        if (!properties.containsKey("password")) {
            properties.setProperty("password", sourceConfig.getPassword());
        }
        if (sourceConfig.getSsl() != null) {
            properties.setProperty("ssl", sourceConfig.getSsl().toString());
        }
        sourceConfig.setProperties(properties);
        return sourceConfig;
    }

    public ReadonlyConfig toReadonlyConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DatabendOptions.URL.key(), this.url);
        map.put(DatabendOptions.USERNAME.key(), this.username);
        map.put(DatabendOptions.PASSWORD.key(), this.password);
        if (this.ssl != null) {
            map.put(DatabendOptions.SSL.key(), this.ssl);
        }
        map.put(DatabendOptions.DATABASE.key(), this.database);
        map.put(DatabendOptions.TABLE.key(), this.table);
        map.put(DatabendOptions.AUTO_COMMIT.key(), this.autoCommit);
        map.put(DatabendOptions.MAX_RETRIES.key(), this.maxRetries);
        if (this.jdbcConfig != null) {
            map.put(DatabendOptions.JDBC_CONFIG.key(), this.jdbcConfig);
        }
        if (this.query != null) {
            map.put(DatabendOptions.QUERY.key(), this.query);
        }
        if (this.sql != null) {
            map.put(DatabendSourceOptions.SQL.key(), this.sql);
        }
        map.put(DatabendOptions.FETCH_SIZE.key(), this.fetchSize);
        return ReadonlyConfig.fromMap(map);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setJdbcConfig(Map<String, String> jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Map<String, String> getJdbcConfig() {
        return this.jdbcConfig;
    }

    public String getQuery() {
        return this.query;
    }

    public String getSql() {
        return this.sql;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return "DatabendSourceConfig(url=" + this.getUrl() + ", ssl=" + this.getSsl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", autoCommit=" + this.getAutoCommit() + ", maxRetries=" + this.getMaxRetries() + ", jdbcConfig=" + this.getJdbcConfig() + ", query=" + this.getQuery() + ", sql=" + this.getSql() + ", fetchSize=" + this.getFetchSize() + ", properties=" + this.getProperties() + ")";
    }
}

