/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.console.sink;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSchemaEvolutionSink;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.schema.SchemaChangeType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.console.sink.ConsoleSinkFactory;
import org.apache.seatunnel.connectors.seatunnel.console.sink.ConsoleSinkWriter;

public class ConsoleSink
extends AbstractSimpleSink<SeaTunnelRow, Void>
implements SupportMultiTableSink,
SupportSchemaEvolutionSink {
    private final SeaTunnelRowType seaTunnelRowType;
    private final boolean isPrintData;
    private final int delayMs;
    private final CatalogTable catalogTable;

    public ConsoleSink(CatalogTable catalogTable, ReadonlyConfig options) {
        this.catalogTable = catalogTable;
        this.isPrintData = (Boolean)options.get(ConsoleSinkFactory.LOG_PRINT_DATA);
        this.delayMs = (Integer)options.get(ConsoleSinkFactory.LOG_PRINT_DELAY);
        this.seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
    }

    @Override
    public ConsoleSinkWriter createWriter(SinkWriter.Context context) {
        return new ConsoleSinkWriter(this.seaTunnelRowType, context, this.isPrintData, this.delayMs);
    }

    public String getPluginName() {
        return "Console";
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }

    public List<SchemaChangeType> supports() {
        return Arrays.asList(SchemaChangeType.ADD_COLUMN, SchemaChangeType.DROP_COLUMN, SchemaChangeType.RENAME_COLUMN, SchemaChangeType.UPDATE_COLUMN);
    }
}

