/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.channel.AbstractChannelRequestHandler;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class PuttyRequestHandler
extends AbstractChannelRequestHandler {
    public static final String REQUEST_SUFFIX = "@putty.projects.tartarus.org";
    public static final Set<PtyMode> PUTTY_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ECHO, PtyMode.ICRNL, PtyMode.ONLCR));
    public static final PuttyRequestHandler INSTANCE = new PuttyRequestHandler();

    @Override
    public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (!PuttyRequestHandler.isPuttyRequest(request)) {
            return RequestHandler.Result.Unsupported;
        }
        String opcode = request.substring(0, request.length() - REQUEST_SUFFIX.length());
        return this.processPuttyOpcode(channel, request, opcode, wantReply, buffer);
    }

    protected RequestHandler.Result processPuttyOpcode(Channel channel, String request, String opcode, boolean wantReply, Buffer buffer) throws Exception {
        if ("simple".equalsIgnoreCase(opcode)) {
            return RequestHandler.Result.ReplySuccess;
        }
        if ("winadj".equalsIgnoreCase(opcode)) {
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processPuttyOpcode(" + opcode + ")[buffer size=" + buffer.available() + "][reply=" + wantReply + "] Unknown request: " + request);
        }
        return RequestHandler.Result.ReplyFailure;
    }

    public static boolean isPuttyRequest(String request) {
        return GenericUtils.length(request) > REQUEST_SUFFIX.length() && request.endsWith(REQUEST_SUFFIX);
    }

    public static boolean isPuttyClient(Session session) {
        return PuttyRequestHandler.isPuttyClient(session == null ? null : session.getClientVersion());
    }

    public static boolean isPuttyClient(String clientVersion) {
        return GenericUtils.length(clientVersion) > "SSH-2.0-".length() && clientVersion.startsWith("SSH-2.0-") && clientVersion.toLowerCase().contains("putty");
    }

    public static Map<PtyMode, Integer> resolveShellTtyOptions(Map<PtyMode, Integer> modes) {
        Map<PtyMode, Integer> resolved = PtyMode.createEnabledOptions(PUTTY_OPTIONS);
        if (MapEntryUtils.size(modes) > 0) {
            resolved.putAll(modes);
        }
        return resolved;
    }
}

