/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.server;

import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.scp.ScpModuleProperties;
import org.apache.sshd.scp.common.ScpException;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpHelper;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.DefaultScpFileOpener;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ServerChannelSessionHolder;
import org.apache.sshd.server.command.AbstractFileSystemCommand;

public class ScpShell
extends AbstractFileSystemCommand
implements ServerChannelSessionHolder {
    public static final String STATUS = "status";
    public static final String ENV_PWD = "PWD";
    public static final String ENV_HOME = "HOME";
    public static final String ENV_LANG = "LANG";
    protected final Map<String, Object> variables = new HashMap<String, Object>();
    protected final Charset nameEncodingCharset;
    protected final Charset envVarsEnodingCharset;
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected Path currentDir;
    protected Path homeDir;
    private final ChannelSession channelSession;

    public ScpShell(ChannelSession channelSession, CloseableExecutorService executorService, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        super(null, executorService);
        this.channelSession = Objects.requireNonNull(channelSession, "No channel session provided");
        this.nameEncodingCharset = ScpModuleProperties.SHELL_NAME_ENCODING_CHARSET.getRequired(channelSession);
        this.envVarsEnodingCharset = ScpModuleProperties.SHELL_ENVVARS_ENCODING_CHARSET.getRequired(channelSession);
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpShell> send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand> receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    @Override
    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public void setFileSystemFactory(FileSystemFactory factory, SessionContext session) throws IOException {
        this.homeDir = factory.getUserHomeDir(session);
        super.setFileSystemFactory(factory, session);
    }

    protected void println(String cmd, Object x, OutputStream out, Charset cs) {
        try {
            String s = x.toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("println({})[{}]: {}", new Object[]{this.getServerChannelSession(), cmd, s.replace('\n', ' ').replace('\t', ' ')});
            }
            out.write(s.getBytes(cs));
            out.write(10);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected void signalError(String cmd, String errorMsg) {
        this.signalError(cmd, errorMsg, this.envVarsEnodingCharset);
    }

    protected void signalError(String cmd, String errorMsg, Charset cs) {
        this.log.warn("{}[{}]: {}", new Object[]{this.getServerChannelSession(), cmd, errorMsg});
        this.println(cmd, errorMsg, this.getErrorStream(), cs);
        this.variables.put(STATUS, 1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 38[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String readLine(Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) >= 0 && c != 10) {
            sb.append((char)c);
        }
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) == '\r') {
            sb.setLength(len - 1);
        }
        return sb.toString();
    }

    protected boolean handleCommandLine(String command) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleCommandLine({}) {}", (Object)this.getServerChannelSession(), (Object)command);
        }
        List<String[]> cmds = this.parse(command);
        OutputStream stdout = this.getOutputStream();
        OutputStream stderr = this.getErrorStream();
        for (String[] argv : cmds) {
            switch (argv[0]) {
                case "echo": {
                    this.echo(argv);
                    break;
                }
                case "pwd": {
                    this.pwd(argv);
                    break;
                }
                case "cd": {
                    this.cd(argv);
                    break;
                }
                case "ls": {
                    this.ls(argv);
                    break;
                }
                case "scp": {
                    this.scp(argv);
                    break;
                }
                case "groups": {
                    this.variables.put(STATUS, 0);
                    break;
                }
                case "printenv": {
                    this.printenv(argv);
                    break;
                }
                case "unset": {
                    this.unset(argv);
                    break;
                }
                case "unalias": {
                    this.variables.put(STATUS, 1);
                    break;
                }
                default: {
                    this.handleUnsupportedCommand(command, argv);
                }
            }
            stdout.flush();
            stderr.flush();
        }
        return true;
    }

    protected void prepareEnvironment(Environment environ) {
        Map<String, String> env = environ.getEnv();
        Locale locale = Locale.getDefault();
        String languageTag = locale.toLanguageTag();
        env.put(ENV_LANG, languageTag.replace('-', '_') + "." + this.nameEncodingCharset.displayName());
        if (this.homeDir != null) {
            env.put(ENV_HOME, this.homeDir.toString());
        }
        this.updatePwdEnvVariable(this.currentDir);
    }

    protected void handleUnsupportedCommand(String command, String[] argv) throws Exception {
        this.log.warn("handleUnsupportedCommand({}) unsupported: {}", (Object)this.getServerChannelSession(), (Object)command);
        this.variables.put(STATUS, 127);
        OutputStream errorStream = this.getErrorStream();
        errorStream.write(("command not found: " + argv[0] + "\n").getBytes(StandardCharsets.US_ASCII));
    }

    protected List<String[]> parse(String command) {
        ArrayList<String[]> cmds = new ArrayList<String[]>();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = new StringBuilder();
        char quote = '\u0000';
        boolean escaped = false;
        for (int i = 0; i < command.length(); ++i) {
            char ch = command.charAt(i);
            if (escaped) {
                arg.append(ch);
                escaped = false;
                continue;
            }
            if (ch == quote) {
                quote = '\u0000';
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                quote = ch;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (quote == '\u0000' && Character.isWhitespace(ch)) {
                if (arg.length() <= 0) continue;
                args.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (quote == '\u0000' && ch == ';') {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg.setLength(0);
                }
                if (!args.isEmpty()) {
                    cmds.add(args.toArray(new String[0]));
                }
                args.clear();
                continue;
            }
            arg.append(ch);
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
            arg.setLength(0);
        }
        if (!args.isEmpty()) {
            cmds.add(args.toArray(new String[0]));
        }
        return cmds;
    }

    protected void printenv(String[] argv) throws Exception {
        Environment environ = this.getEnvironment();
        Map<String, String> envValues = environ.getEnv();
        OutputStream stdout = this.getOutputStream();
        if (argv.length == 1) {
            envValues.entrySet().stream().forEach(e -> this.println(argv[0], (String)e.getKey() + "=" + (String)e.getValue(), stdout, this.envVarsEnodingCharset));
            this.variables.put(STATUS, 0);
            return;
        }
        if (argv.length != 2) {
            this.signalError(argv[0], "printenv: only one variable value at a time");
            return;
        }
        String varName = argv[1];
        String varValue = this.resolveEnvironmentVariable(varName, envValues);
        if (varValue == null) {
            this.signalError(argv[0], "printenv: variable not set " + varName);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("printenv({}) {}={}", new Object[]{this.getServerChannelSession(), varName, varValue});
        }
        this.println(argv[0], varValue, stdout, this.envVarsEnodingCharset);
        this.variables.put(STATUS, 0);
    }

    protected String resolveEnvironmentVariable(String varName, Map<String, String> envValues) {
        return envValues.get(varName);
    }

    protected void unset(String[] argv) throws Exception {
        if (argv.length != 2) {
            this.signalError(argv[0], "unset: exactly one argument is expected");
            return;
        }
        Environment environ = this.getEnvironment();
        Map<String, String> envValues = environ.getEnv();
        String varName = argv[1];
        String varValue = envValues.remove(varName);
        if (this.log.isDebugEnabled()) {
            this.log.debug("unset({}) {}={}", new Object[]{this.getServerChannelSession(), varName, varValue});
        }
        this.variables.put(STATUS, varValue == null ? 1 : 0);
    }

    protected void scp(String[] argv) throws Exception {
        boolean optR = false;
        boolean optT = false;
        boolean optF = false;
        boolean optD = false;
        boolean optP = false;
        boolean isOption = true;
        String path = null;
        for (int i = 1; i < argv.length; ++i) {
            String argVal = argv[i];
            if (GenericUtils.isEmpty(argVal)) {
                this.signalError(argv[0], "scp: empty argument not allowed");
                return;
            }
            if (isOption && argVal.charAt(0) == '-') {
                if (argVal.length() != 2) {
                    this.signalError(argv[0], "scp: only one option at a time may be specified");
                    return;
                }
                char optVal = argVal.charAt(1);
                switch (optVal) {
                    case 'r': {
                        optR = true;
                        break;
                    }
                    case 't': {
                        optT = true;
                        break;
                    }
                    case 'f': {
                        optF = true;
                        break;
                    }
                    case 'd': {
                        optD = true;
                        break;
                    }
                    case 'p': {
                        optP = true;
                        break;
                    }
                    default: {
                        this.signalError(argv[0], "scp: unsupported option: " + argVal);
                        return;
                    }
                }
                continue;
            }
            if (path == null) {
                path = argVal;
                isOption = false;
                continue;
            }
            this.signalError(argv[0], "scp: one and only one path argument expected");
            return;
        }
        if (optT && optF || !optT && !optF) {
            this.signalError(argv[0], "scp: one and only one of -t and -f option expected");
            return;
        }
        this.doScp(path, optR, optT, optF, optD, optP);
    }

    protected void doScp(String path, boolean optR, boolean optT, boolean optF, boolean optD, boolean optP) throws Exception {
        try {
            ChannelSession channel = this.getServerChannelSession();
            ScpHelper helper = new ScpHelper(channel.getSession(), this.getInputStream(), this.getOutputStream(), this.fileSystem, this.opener, this.listener);
            Path localPath = this.currentDir.resolve(path);
            if (optT) {
                helper.receive(localPath, optR, optD, optP, this.receiveBufferSize);
            } else {
                helper.send(Collections.singletonList(localPath.toString()), optR, optP, this.sendBufferSize);
            }
            this.variables.put(STATUS, 0);
        }
        catch (IOException e) {
            int exitValue;
            Integer statusCode = e instanceof ScpException ? ((ScpException)e).getExitStatus() : null;
            int n = exitValue = statusCode == null ? 2 : statusCode;
            if (exitValue == 0 || exitValue == 1) {
                exitValue = 2;
            }
            String exitMessage = GenericUtils.trimToEmpty(e.getMessage());
            ScpAckInfo.sendAck(this.getOutputStream(), StandardCharsets.UTF_8, exitValue, exitMessage);
            this.variables.put(STATUS, exitValue);
        }
    }

    protected void echo(String[] argv) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (int k = 1; k < argv.length; ++k) {
            String arg = argv[k];
            if (buf.length() > 0) {
                buf.append(' ');
            }
            int vstart = -1;
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (vstart >= 0) {
                    if (c == '_' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                    if (vstart == i) {
                        buf.append('$');
                    } else {
                        String n = arg.substring(vstart, i);
                        Object v = this.variables.get(n);
                        if (v != null) {
                            buf.append(v);
                        }
                    }
                    vstart = -1;
                    continue;
                }
                if (c == '$') {
                    vstart = i + 1;
                    continue;
                }
                buf.append(c);
            }
            if (vstart < 0) continue;
            String n = arg.substring(vstart);
            if (n.isEmpty()) {
                buf.append('$');
                continue;
            }
            Object v = this.variables.get(n);
            if (v == null) continue;
            buf.append(v);
        }
        this.println(argv[0], buf, this.getOutputStream(), this.nameEncodingCharset);
        this.variables.put(STATUS, 0);
    }

    protected void pwd(String[] argv) throws Exception {
        if (argv.length != 1) {
            this.signalError(argv[0], "pwd: too many arguments");
        } else {
            this.println(argv[0], this.currentDir, this.getOutputStream(), this.nameEncodingCharset);
            this.variables.put(STATUS, 0);
        }
    }

    protected void cd(String[] argv) throws Exception {
        if (argv.length == 1) {
            if (this.homeDir != null) {
                this.currentDir = this.homeDir;
                this.updatePwdEnvVariable(this.currentDir);
                this.variables.put(STATUS, 0);
            } else {
                this.signalError(argv[0], "No home directory to return to");
            }
            return;
        }
        if (argv.length != 2) {
            this.signalError(argv[0], "cd: too many or too few arguments");
            return;
        }
        String path = argv[1];
        if (GenericUtils.isEmpty(path)) {
            this.signalError(argv[0], "cd: empty target");
            return;
        }
        Path cwd = this.currentDir;
        if (!Files.exists(cwd = cwd.resolve(path).toAbsolutePath().normalize(), new LinkOption[0])) {
            this.signalError(argv[0], "no such file or directory: " + path, this.nameEncodingCharset);
        } else if (!Files.isDirectory(cwd, new LinkOption[0])) {
            this.signalError(argv[0], "not a directory: " + path, this.nameEncodingCharset);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("cd - {} => {}", (Object)this.currentDir, (Object)cwd);
            }
            this.currentDir = cwd;
            this.updatePwdEnvVariable(this.currentDir);
            this.variables.put(STATUS, 0);
        }
    }

    protected void updatePwdEnvVariable(Path pwd) {
        Environment environ = this.getEnvironment();
        Map<String, String> envVars = environ.getEnv();
        envVars.put(ENV_PWD, pwd.toString());
    }

    protected void ls(String[] argv) throws Exception {
        boolean optListAll = false;
        boolean optDirAsPlain = false;
        boolean optLong = false;
        boolean optFullTime = false;
        String path = null;
        for (int k = 1; k < argv.length; ++k) {
            String argValue = argv[k];
            if (GenericUtils.isEmpty(argValue)) {
                this.signalError(argv[0], "ls: empty argument not allowed");
                return;
            }
            if (argValue.equals("--full-time")) {
                optFullTime = true;
                continue;
            }
            if (argValue.charAt(0) == '-') {
                int argLen = argValue.length();
                if (argLen == 1) {
                    this.signalError(argv[0], "ls: no option specified");
                    return;
                }
                block6: for (int i = 1; i < argLen; ++i) {
                    char optValue = argValue.charAt(i);
                    switch (optValue) {
                        case 'a': {
                            optListAll = true;
                            continue block6;
                        }
                        case 'd': {
                            optDirAsPlain = true;
                            continue block6;
                        }
                        case 'l': {
                            optLong = true;
                            continue block6;
                        }
                        default: {
                            this.signalError(argv[0], "unsupported option: -" + optValue);
                            return;
                        }
                    }
                }
                continue;
            }
            if (path == null) {
                path = argValue;
                continue;
            }
            this.signalError(argv[0], "unsupported option: " + argValue);
            return;
        }
        this.doLs(argv[0], path, optListAll, optLong, optFullTime);
    }

    protected void doLs(String cmd, String path, boolean optListAll, boolean optLong, boolean optFullTime) throws Exception {
        Predicate<Path> filter = p -> {
            String fileName = p.getFileName().toString();
            return optListAll || fileName.equals(".") || fileName.equals("..") || !fileName.startsWith(".");
        };
        Stream<Path> files = path != null ? Stream.of(this.currentDir.resolve(path)) : Stream.concat(Stream.of(".", "..").map(this.currentDir::resolve), Files.list(this.currentDir));
        OutputStream stdout = this.getOutputStream();
        OutputStream stderr = this.getErrorStream();
        this.variables.put(STATUS, 0);
        files.filter(filter).map(p -> new PathEntry((Path)p, this.currentDir)).sorted().forEach(p -> {
            try {
                String str = p.display(optLong, optFullTime);
                this.println(cmd, str, stdout, this.nameEncodingCharset);
            }
            catch (NoSuchFileException e) {
                this.println(cmd, cmd + ": " + p.path.toString() + ": no such file or directory", stderr, this.nameEncodingCharset);
                this.variables.put(STATUS, 1);
            }
        });
    }

    protected static class PathEntry
    implements Comparable<PathEntry> {
        public static final DateTimeFormatter FULL_TIME_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd HH:mm:ss yyyy");
        public static final DateTimeFormatter TIME_ONLY_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd HH:mm");
        public static final DateTimeFormatter YEAR_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd  yyyy");
        protected final Path abs;
        protected final Path path;
        protected final Map<String, Object> attributes;

        public PathEntry(Path abs, Path root) {
            this.abs = abs;
            this.path = abs.startsWith(root) ? root.relativize(abs) : abs;
            this.attributes = PathEntry.readAttributes(abs);
        }

        @Override
        public int compareTo(PathEntry o) {
            return this.path.toString().compareTo(o.path.toString());
        }

        public String toString() {
            return Objects.toString(this.abs);
        }

        public String display(boolean optLongDisplay, boolean optFullTime) throws NoSuchFileException {
            if (this.attributes.isEmpty()) {
                throw new NoSuchFileException(this.path.toString());
            }
            String abbrev = this.shortDisplay();
            if (!optLongDisplay) {
                return abbrev;
            }
            StringBuilder sb = new StringBuilder(abbrev.length() + 64);
            if (this.is("isDirectory")) {
                sb.append('d');
            } else if (this.is("isSymbolicLink")) {
                sb.append('l');
            } else if (this.is("isOther")) {
                sb.append('o');
            } else {
                sb.append('-');
            }
            EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)this.attributes.get("permissions");
            if (perms == null) {
                perms = EnumSet.noneOf(PosixFilePermission.class);
            }
            sb.append(PosixFilePermissions.toString(perms));
            Object nlinkValue = this.attributes.get("nlink");
            sb.append(' ').append(String.format("%3s", nlinkValue != null ? nlinkValue : "1"));
            this.appendOwnerInformation(sb, "owner", "owner");
            this.appendOwnerInformation(sb, "group", "group");
            Number length = (Number)this.attributes.get("size");
            if (length == null) {
                length = 0L;
            }
            sb.append(' ').append(String.format("%1$8s", length));
            String timeValue = PathEntry.toString((FileTime)this.attributes.get("lastModifiedTime"), optFullTime);
            sb.append(' ').append(timeValue);
            sb.append(' ').append(abbrev);
            return sb.toString();
        }

        protected boolean is(String attr) {
            Object d = this.attributes.get(attr);
            return d instanceof Boolean && (Boolean)d != false;
        }

        protected StringBuilder appendOwnerInformation(StringBuilder sb, String attr, String defaultValue) {
            String owner = Objects.toString(this.attributes.get(attr), null);
            if (GenericUtils.isEmpty(owner)) {
                owner = defaultValue;
            }
            if (owner.length() > 8) {
                owner = owner.substring(0, 8);
            }
            sb.append(' ').append(owner);
            for (int index = owner.length(); index < 8; ++index) {
                sb.append(' ');
            }
            return sb;
        }

        protected String shortDisplay() {
            String str;
            if (this.is("isSymbolicLink")) {
                try {
                    Path l = Files.readSymbolicLink(this.abs);
                    return this.path + " -> " + l;
                }
                catch (IOException l) {
                    // empty catch block
                }
            }
            if ((str = this.path.toString()).isEmpty()) {
                return this.abs.getFileName().toString();
            }
            return str;
        }

        protected static String toString(FileTime time, boolean optFullTime) {
            long millis;
            long l = millis = time != null ? time.toMillis() : -1L;
            if (millis < 0L) {
                return "------------";
            }
            ZonedDateTime dt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
            if (optFullTime) {
                return FULL_TIME_VALUE_FORMATTER.format(dt);
            }
            if (System.currentTimeMillis() - millis < 15811200000L) {
                return TIME_ONLY_VALUE_FORMATTER.format(dt);
            }
            return YEAR_VALUE_FORMATTER.format(dt);
        }

        protected static Map<String, Object> readAttributes(Path path) {
            TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            FileSystem fs = path.getFileSystem();
            Set<String> views = fs.supportedFileAttributeViews();
            for (String view : views) {
                try {
                    Map<String, Object> ta = Files.readAttributes(path, view + ":*", IoUtils.getLinkOptions(false));
                    ta.forEach(attrs::putIfAbsent);
                }
                catch (IOException iOException) {}
            }
            if (!attrs.isEmpty()) {
                attrs.computeIfAbsent("isExecutable", s -> Files.isExecutable(path));
                attrs.computeIfAbsent("permissions", s -> IoUtils.getPermissionsFromFile(path.toFile()));
            }
            return attrs;
        }
    }
}

