/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhousePart;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.ClickhouseSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.Splitter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlStrategySplitter
implements Splitter,
AutoCloseable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(SqlStrategySplitter.class);
    private static final long serialVersionUID = -6512116577805882794L;

    @Override
    public List<ClickhouseSourceSplit> generateSplits(ClickhouseSourceTable clickhouseSourceTable, List<Shard> clusterShardList) {
        log.info("start sql strategy splitter generate splits. table: {}", (Object)clickhouseSourceTable.getTablePath());
        if (clickhouseSourceTable.isComplexSql()) {
            log.info("Complex SQL detected, creating a single split for the query.");
            return this.createSingleSplit(clickhouseSourceTable, clusterShardList);
        }
        ArrayList<ClickhouseSourceSplit> splits = new ArrayList<ClickhouseSourceSplit>();
        ClickhouseTable clickhouseTable = clickhouseSourceTable.getClickhouseTable();
        String querySql = this.rewriteQueryForLocalTable(clickhouseSourceTable, clickhouseTable);
        clusterShardList.forEach(shard -> splits.add(new ClickhouseSourceSplit(TablePath.of((String)clickhouseTable.getLocalDatabase(), (String)clickhouseTable.getLocalTableName()), TablePath.of((String)clickhouseTable.getDatabase(), (String)clickhouseTable.getTableName()), (List<ClickhousePart>)new ArrayList<ClickhousePart>(), (Shard)shard, querySql, 0, this.createSplitId(clickhouseSourceTable.getTablePath(), (Shard)shard, splits.size()))));
        log.info("generate splits size: {}", (Object)splits.size());
        return splits;
    }

    @Override
    public String createSplitId(TablePath tablePath, Shard shard, int index) {
        return String.format("%s-%s-%s", tablePath, shard.hashCode(), index);
    }

    private String rewriteQueryForLocalTable(ClickhouseSourceTable clickhouseSourceTable, ClickhouseTable clickhouseTable) {
        if (clickhouseTable.getDistributedEngine() != null) {
            String localTableId = clickhouseTable.getLocalTableIdentifier();
            String querySql = clickhouseSourceTable.getOriginQuery();
            return querySql.replace(ClickhouseUtil.extractTablePathFromSql(querySql).getFullName(), localTableId);
        }
        return clickhouseSourceTable.getOriginQuery();
    }

    private List<ClickhouseSourceSplit> createSingleSplit(ClickhouseSourceTable clickhouseSourceTable, List<Shard> clusterShardList) {
        return Collections.singletonList(new ClickhouseSourceSplit(clickhouseSourceTable.getTablePath(), clickhouseSourceTable.getTablePath(), new ArrayList<ClickhousePart>(), clusterShardList.get(0), clickhouseSourceTable.getOriginQuery(), 0, this.createSplitId(clickhouseSourceTable.getTablePath(), clusterShardList.get(0), 0)));
    }

    @Override
    public void close() {
    }
}

