/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.ArrayInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.BigDecimalInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.ClickhouseFieldInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.DateInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.DateTimeInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.DoubleInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.FloatInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.IntInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.LongInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.MapInjectFunction;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.StringInjectFunction;

public class JdbcRowConverter
implements Serializable {
    private static final Pattern NULLABLE = Pattern.compile("Nullable\\((.*)\\)");
    private static final Pattern LOW_CARDINALITY = Pattern.compile("LowCardinality\\((.*)\\)");
    private static final ClickhouseFieldInjectFunction DEFAULT_INJECT_FUNCTION = new StringInjectFunction();
    private final String[] projectionFields;
    private final Map<String, ClickhouseFieldInjectFunction> fieldInjectFunctionMap;
    private final Map<String, Function<SeaTunnelRow, Object>> fieldGetterMap;

    public JdbcRowConverter(@NonNull SeaTunnelRowType rowType, @NonNull Map<String, String> clickhouseTableSchema, @NonNull String[] projectionFields) {
        if (rowType == null) {
            throw new NullPointerException("rowType is marked non-null but is null");
        }
        if (clickhouseTableSchema == null) {
            throw new NullPointerException("clickhouseTableSchema is marked non-null but is null");
        }
        if (projectionFields == null) {
            throw new NullPointerException("projectionFields is marked non-null but is null");
        }
        this.projectionFields = projectionFields;
        this.fieldInjectFunctionMap = this.createFieldInjectFunctionMap(projectionFields, clickhouseTableSchema);
        this.fieldGetterMap = this.createFieldGetterMap(projectionFields, rowType);
    }

    public PreparedStatement toExternal(SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        for (int i = 0; i < this.projectionFields.length; ++i) {
            String fieldName = this.projectionFields[i];
            Object fieldValue = this.fieldGetterMap.get(fieldName).apply(row);
            if (fieldValue == null) {
                statement.setObject(i + 1, null);
                continue;
            }
            this.fieldInjectFunctionMap.getOrDefault(fieldName, DEFAULT_INJECT_FUNCTION).injectFields(statement, i + 1, fieldValue);
        }
        return statement;
    }

    private Map<String, ClickhouseFieldInjectFunction> createFieldInjectFunctionMap(String[] fields, Map<String, String> clickhouseTableSchema) {
        HashMap<String, ClickhouseFieldInjectFunction> fieldInjectFunctionMap = new HashMap<String, ClickhouseFieldInjectFunction>();
        for (String field : fields) {
            String fieldType = clickhouseTableSchema.get(field);
            ClickhouseFieldInjectFunction injectFunction = Arrays.asList(new ArrayInjectFunction(), new MapInjectFunction(), new BigDecimalInjectFunction(), new DateInjectFunction(), new DateTimeInjectFunction(), new LongInjectFunction(), new DoubleInjectFunction(), new FloatInjectFunction(), new IntInjectFunction(), new StringInjectFunction()).stream().filter(f -> f.isCurrentFieldType(this.unwrapCommonPrefix(fieldType))).findFirst().orElse(new StringInjectFunction());
            fieldInjectFunctionMap.put(field, injectFunction);
        }
        return fieldInjectFunctionMap;
    }

    private Map<String, Function<SeaTunnelRow, Object>> createFieldGetterMap(String[] fields, SeaTunnelRowType rowType) {
        HashMap<String, Function<SeaTunnelRow, Object>> fieldGetterMap = new HashMap<String, Function<SeaTunnelRow, Object>>();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            int fieldIndex = rowType.indexOf(fieldName);
            fieldGetterMap.put(fieldName, row -> row.getField(fieldIndex));
        }
        return fieldGetterMap;
    }

    private String unwrapCommonPrefix(String fieldType) {
        Matcher nullMatcher = NULLABLE.matcher(fieldType);
        Matcher lowMatcher = LOW_CARDINALITY.matcher(fieldType);
        if (nullMatcher.matches()) {
            return nullMatcher.group(1);
        }
        if (lowMatcher.matches()) {
            return lowMatcher.group(1);
        }
        return fieldType;
    }
}

