/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.shard;

import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Shard
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final int shardNum;
    private final int replicaNum;
    private final ClickHouseNode node;
    private int hashCode = -1;

    public Shard(int shardNum, int shardWeight, int replicaNum, String hostname, String hostAddress, int port, String database, String username, String password, Map<String, String> options) {
        this.shardNum = shardNum;
        this.replicaNum = replicaNum;
        this.node = ClickHouseNode.builder().host(hostname).port(ClickHouseProtocol.HTTP, port).database(database).weight(shardWeight).credentials(ClickHouseCredentials.fromUserAndPassword(username, password)).options(options).build();
    }

    public Shard(int shardNum, int replicaNum, ClickHouseNode node) {
        this.shardNum = shardNum;
        this.replicaNum = replicaNum;
        this.node = node;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public int getReplicaNum() {
        return this.replicaNum;
    }

    public ClickHouseNode getNode() {
        return this.node;
    }

    public String getJdbcUrl() {
        return "jdbc:clickhouse://" + this.node.getAddress().getHostName() + ":" + this.node.getAddress().getPort() + "/" + this.node.getDatabase().get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shard shard = (Shard)o;
        return this.shardNum == shard.shardNum && this.replicaNum == shard.replicaNum && this.hashCode == shard.hashCode && Objects.equals(this.node, shard.node);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Objects.hash(this.shardNum, this.replicaNum, this.node, this.hashCode);
        }
        return this.hashCode;
    }
}

