/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.ShardMetadata;

public class ReaderOption
implements Serializable {
    private ShardMetadata shardMetadata;
    private String[] primaryKeys;
    private boolean allowExperimentalLightweightDelete;
    private boolean supportUpsert;
    private String tableEngine;
    private Map<String, String> tableSchema;
    private SeaTunnelRowType seaTunnelRowType;
    private Properties properties;
    private int bulkSize;

    ReaderOption(ShardMetadata shardMetadata, String[] primaryKeys, boolean allowExperimentalLightweightDelete, boolean supportUpsert, String tableEngine, Map<String, String> tableSchema, SeaTunnelRowType seaTunnelRowType, Properties properties, int bulkSize) {
        this.shardMetadata = shardMetadata;
        this.primaryKeys = primaryKeys;
        this.allowExperimentalLightweightDelete = allowExperimentalLightweightDelete;
        this.supportUpsert = supportUpsert;
        this.tableEngine = tableEngine;
        this.tableSchema = tableSchema;
        this.seaTunnelRowType = seaTunnelRowType;
        this.properties = properties;
        this.bulkSize = bulkSize;
    }

    public static ReaderOptionBuilder builder() {
        return new ReaderOptionBuilder();
    }

    public ShardMetadata getShardMetadata() {
        return this.shardMetadata;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public boolean isAllowExperimentalLightweightDelete() {
        return this.allowExperimentalLightweightDelete;
    }

    public boolean isSupportUpsert() {
        return this.supportUpsert;
    }

    public String getTableEngine() {
        return this.tableEngine;
    }

    public Map<String, String> getTableSchema() {
        return this.tableSchema;
    }

    public SeaTunnelRowType getSeaTunnelRowType() {
        return this.seaTunnelRowType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getBulkSize() {
        return this.bulkSize;
    }

    public void setSeaTunnelRowType(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public static class ReaderOptionBuilder {
        private ShardMetadata shardMetadata;
        private String[] primaryKeys;
        private boolean allowExperimentalLightweightDelete;
        private boolean supportUpsert;
        private String tableEngine;
        private Map<String, String> tableSchema;
        private SeaTunnelRowType seaTunnelRowType;
        private Properties properties;
        private int bulkSize;

        ReaderOptionBuilder() {
        }

        public ReaderOptionBuilder shardMetadata(ShardMetadata shardMetadata) {
            this.shardMetadata = shardMetadata;
            return this;
        }

        public ReaderOptionBuilder primaryKeys(String[] primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public ReaderOptionBuilder allowExperimentalLightweightDelete(boolean allowExperimentalLightweightDelete) {
            this.allowExperimentalLightweightDelete = allowExperimentalLightweightDelete;
            return this;
        }

        public ReaderOptionBuilder supportUpsert(boolean supportUpsert) {
            this.supportUpsert = supportUpsert;
            return this;
        }

        public ReaderOptionBuilder tableEngine(String tableEngine) {
            this.tableEngine = tableEngine;
            return this;
        }

        public ReaderOptionBuilder tableSchema(Map<String, String> tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        public ReaderOptionBuilder seaTunnelRowType(SeaTunnelRowType seaTunnelRowType) {
            this.seaTunnelRowType = seaTunnelRowType;
            return this;
        }

        public ReaderOptionBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public ReaderOptionBuilder bulkSize(int bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public ReaderOption build() {
            return new ReaderOption(this.shardMetadata, this.primaryKeys, this.allowExperimentalLightweightDelete, this.supportUpsert, this.tableEngine, this.tableSchema, this.seaTunnelRowType, this.properties, this.bulkSize);
        }

        public String toString() {
            return "ReaderOption.ReaderOptionBuilder(shardMetadata=" + this.shardMetadata + ", primaryKeys=" + Arrays.deepToString(this.primaryKeys) + ", allowExperimentalLightweightDelete=" + this.allowExperimentalLightweightDelete + ", supportUpsert=" + this.supportUpsert + ", tableEngine=" + this.tableEngine + ", tableSchema=" + this.tableSchema + ", seaTunnelRowType=" + this.seaTunnelRowType + ", properties=" + this.properties + ", bulkSize=" + this.bulkSize + ")";
        }
    }
}

