/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClickhouseTableConfig
implements Serializable {
    private static final long serialVersionUID = -6133096497433624821L;
    @JsonProperty(value="table_path")
    private String tablePath;
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="filter_query")
    private String filterQuery;
    @JsonProperty(value="partition_list")
    private List<String> partitionList;
    @JsonProperty(value="batch_size")
    private int batchSize;
    @JsonProperty(value="split_size")
    private int splitSize;
    private boolean isSqlStrategyRead;

    public ClickhouseTableConfig() {
    }

    public static List<ClickhouseTableConfig> of(ReadonlyConfig readonlyConfig) {
        List<ClickhouseTableConfig> tableList;
        if (readonlyConfig.getOptional(ClickhouseSourceOptions.TABLE_LIST).isPresent()) {
            tableList = (List<ClickhouseTableConfig>)readonlyConfig.get(ClickhouseSourceOptions.TABLE_LIST);
        } else {
            ClickhouseTableConfig tableConfig = ClickhouseTableConfig.builder().tablePath((String)readonlyConfig.get(ClickhouseBaseOptions.TABLE_PATH)).sql((String)readonlyConfig.get(ClickhouseSourceOptions.SQL)).filterQuery((String)readonlyConfig.get(ClickhouseSourceOptions.CLICKHOUSE_FILTER_QUERY)).partitionList((List)readonlyConfig.get(ClickhouseSourceOptions.CLICKHOUSE_PARTITION_LIST)).batchSize((Integer)readonlyConfig.get(ClickhouseSourceOptions.CLICKHOUSE_BATCH_SIZE)).splitSize((Integer)readonlyConfig.get(ClickhouseSourceOptions.CLICKHOUSE_SPLIT_SIZE)).build();
            tableList = Collections.singletonList(tableConfig);
        }
        if (tableList == null || tableList.isEmpty()) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)ClickhouseConnectorErrorCode.GET_TABLE_LIST_CONFIG_ERROR, String.format("PluginName: %s, PluginType: %s, Message: %s", "Clickhouse", PluginType.SOURCE, "Get table list config error."));
        }
        for (ClickhouseTableConfig tableConfig : tableList) {
            if (StringUtils.isEmpty(tableConfig.getTablePath()) && StringUtils.isEmpty(tableConfig.getSql())) {
                throw new IllegalArgumentException("`table_path` and `sql` parameter cannot be both empty.");
            }
            if (tableConfig.getBatchSize() <= 0) {
                tableConfig.setBatchSize((Integer)ClickhouseSourceOptions.CLICKHOUSE_BATCH_SIZE.defaultValue());
            }
            if (tableConfig.getSplitSize() <= 0) {
                tableConfig.setSplitSize((Integer)ClickhouseSourceOptions.CLICKHOUSE_SPLIT_SIZE.defaultValue());
            }
            tableConfig.setSqlStrategyRead(StringUtils.isNotEmpty(tableConfig.getSql()));
        }
        return tableList;
    }

    public TablePath getTableIdentifier() {
        if (StringUtils.isEmpty(this.tablePath)) {
            return ClickhouseUtil.extractTablePathFromSql(this.sql);
        }
        return TablePath.of((String)this.tablePath);
    }

    ClickhouseTableConfig(String tablePath, String sql, String filterQuery, List<String> partitionList, int batchSize, int splitSize, boolean isSqlStrategyRead) {
        this.tablePath = tablePath;
        this.sql = sql;
        this.filterQuery = filterQuery;
        this.partitionList = partitionList;
        this.batchSize = batchSize;
        this.splitSize = splitSize;
        this.isSqlStrategyRead = isSqlStrategyRead;
    }

    public static ClickhouseTableConfigBuilder builder() {
        return new ClickhouseTableConfigBuilder();
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public String getSql() {
        return this.sql;
    }

    public String getFilterQuery() {
        return this.filterQuery;
    }

    public List<String> getPartitionList() {
        return this.partitionList;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getSplitSize() {
        return this.splitSize;
    }

    public boolean isSqlStrategyRead() {
        return this.isSqlStrategyRead;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    public void setPartitionList(List<String> partitionList) {
        this.partitionList = partitionList;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSplitSize(int splitSize) {
        this.splitSize = splitSize;
    }

    public void setSqlStrategyRead(boolean isSqlStrategyRead) {
        this.isSqlStrategyRead = isSqlStrategyRead;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickhouseTableConfig)) {
            return false;
        }
        ClickhouseTableConfig other = (ClickhouseTableConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getSplitSize() != other.getSplitSize()) {
            return false;
        }
        if (this.isSqlStrategyRead() != other.isSqlStrategyRead()) {
            return false;
        }
        String this$tablePath = this.getTablePath();
        String other$tablePath = other.getTablePath();
        if (this$tablePath == null ? other$tablePath != null : !this$tablePath.equals(other$tablePath)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$filterQuery = this.getFilterQuery();
        String other$filterQuery = other.getFilterQuery();
        if (this$filterQuery == null ? other$filterQuery != null : !this$filterQuery.equals(other$filterQuery)) {
            return false;
        }
        List<String> this$partitionList = this.getPartitionList();
        List<String> other$partitionList = other.getPartitionList();
        return !(this$partitionList == null ? other$partitionList != null : !((Object)this$partitionList).equals(other$partitionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClickhouseTableConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getSplitSize();
        result = result * 59 + (this.isSqlStrategyRead() ? 79 : 97);
        String $tablePath = this.getTablePath();
        result = result * 59 + ($tablePath == null ? 43 : $tablePath.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $filterQuery = this.getFilterQuery();
        result = result * 59 + ($filterQuery == null ? 43 : $filterQuery.hashCode());
        List<String> $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : ((Object)$partitionList).hashCode());
        return result;
    }

    public String toString() {
        return "ClickhouseTableConfig(tablePath=" + this.getTablePath() + ", sql=" + this.getSql() + ", filterQuery=" + this.getFilterQuery() + ", partitionList=" + this.getPartitionList() + ", batchSize=" + this.getBatchSize() + ", splitSize=" + this.getSplitSize() + ", isSqlStrategyRead=" + this.isSqlStrategyRead() + ")";
    }

    public static class ClickhouseTableConfigBuilder {
        private String tablePath;
        private String sql;
        private String filterQuery;
        private List<String> partitionList;
        private int batchSize;
        private int splitSize;
        private boolean isSqlStrategyRead;

        ClickhouseTableConfigBuilder() {
        }

        public ClickhouseTableConfigBuilder tablePath(String tablePath) {
            this.tablePath = tablePath;
            return this;
        }

        public ClickhouseTableConfigBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public ClickhouseTableConfigBuilder filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ClickhouseTableConfigBuilder partitionList(List<String> partitionList) {
            this.partitionList = partitionList;
            return this;
        }

        public ClickhouseTableConfigBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public ClickhouseTableConfigBuilder splitSize(int splitSize) {
            this.splitSize = splitSize;
            return this;
        }

        public ClickhouseTableConfigBuilder isSqlStrategyRead(boolean isSqlStrategyRead) {
            this.isSqlStrategyRead = isSqlStrategyRead;
            return this;
        }

        public ClickhouseTableConfig build() {
            return new ClickhouseTableConfig(this.tablePath, this.sql, this.filterQuery, this.partitionList, this.batchSize, this.splitSize, this.isSqlStrategyRead);
        }

        public String toString() {
            return "ClickhouseTableConfig.ClickhouseTableConfigBuilder(tablePath=" + this.tablePath + ", sql=" + this.sql + ", filterQuery=" + this.filterQuery + ", partitionList=" + this.partitionList + ", batchSize=" + this.batchSize + ", splitSize=" + this.splitSize + ", isSqlStrategyRead=" + this.isSqlStrategyRead + ")";
        }
    }
}

