/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.config;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseTableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseSourceConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseSourceConfig.class);
    private static final long serialVersionUID = -5139627460951339176L;
    private String host;
    private String username;
    private String password;
    private Map<String, String> clickhouseConfig;
    private String serverTimeZone;
    private List<ClickhouseTableConfig> tableconfigList;

    public static ClickhouseSourceConfig of(ReadonlyConfig config) {
        Builder builder = ClickhouseSourceConfig.builder();
        builder.host((String)config.get(ClickhouseBaseOptions.HOST));
        builder.username((String)config.get(ClickhouseBaseOptions.USERNAME));
        builder.password((String)config.get(ClickhouseBaseOptions.PASSWORD));
        builder.clickhouseConfig((Map)config.get(ClickhouseBaseOptions.CLICKHOUSE_CONFIG));
        builder.serverTimeZone((String)config.get(ClickhouseBaseOptions.SERVER_TIME_ZONE));
        builder.tableconfigList(ClickhouseTableConfig.of(config));
        return builder.build();
    }

    ClickhouseSourceConfig(String host, String username, String password, Map<String, String> clickhouseConfig, String serverTimeZone, List<ClickhouseTableConfig> tableconfigList) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.clickhouseConfig = clickhouseConfig;
        this.serverTimeZone = serverTimeZone;
        this.tableconfigList = tableconfigList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getClickhouseConfig() {
        return this.clickhouseConfig;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public List<ClickhouseTableConfig> getTableconfigList() {
        return this.tableconfigList;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClickhouseConfig(Map<String, String> clickhouseConfig) {
        this.clickhouseConfig = clickhouseConfig;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setTableconfigList(List<ClickhouseTableConfig> tableconfigList) {
        this.tableconfigList = tableconfigList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickhouseSourceConfig)) {
            return false;
        }
        ClickhouseSourceConfig other = (ClickhouseSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<String, String> this$clickhouseConfig = this.getClickhouseConfig();
        Map<String, String> other$clickhouseConfig = other.getClickhouseConfig();
        if (this$clickhouseConfig == null ? other$clickhouseConfig != null : !((Object)this$clickhouseConfig).equals(other$clickhouseConfig)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        List<ClickhouseTableConfig> this$tableconfigList = this.getTableconfigList();
        List<ClickhouseTableConfig> other$tableconfigList = other.getTableconfigList();
        return !(this$tableconfigList == null ? other$tableconfigList != null : !((Object)this$tableconfigList).equals(other$tableconfigList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClickhouseSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<String, String> $clickhouseConfig = this.getClickhouseConfig();
        result = result * 59 + ($clickhouseConfig == null ? 43 : ((Object)$clickhouseConfig).hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        List<ClickhouseTableConfig> $tableconfigList = this.getTableconfigList();
        result = result * 59 + ($tableconfigList == null ? 43 : ((Object)$tableconfigList).hashCode());
        return result;
    }

    public String toString() {
        return "ClickhouseSourceConfig(host=" + this.getHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", clickhouseConfig=" + this.getClickhouseConfig() + ", serverTimeZone=" + this.getServerTimeZone() + ", tableconfigList=" + this.getTableconfigList() + ")";
    }

    public static class Builder {
        private String host;
        private String username;
        private String password;
        private Map<String, String> clickhouseConfig;
        private String serverTimeZone;
        private List<ClickhouseTableConfig> tableconfigList;

        Builder() {
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder clickhouseConfig(Map<String, String> clickhouseConfig) {
            this.clickhouseConfig = clickhouseConfig;
            return this;
        }

        public Builder serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder tableconfigList(List<ClickhouseTableConfig> tableconfigList) {
            this.tableconfigList = tableconfigList;
            return this;
        }

        public ClickhouseSourceConfig build() {
            return new ClickhouseSourceConfig(this.host, this.username, this.password, this.clickhouseConfig, this.serverTimeZone, this.tableconfigList);
        }

        public String toString() {
            return "ClickhouseSourceConfig.Builder(host=" + this.host + ", username=" + this.username + ", password=" + this.password + ", clickhouseConfig=" + this.clickhouseConfig + ", serverTimeZone=" + this.serverTimeZone + ", tableconfigList=" + this.tableconfigList + ")";
        }
    }
}

