/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(OracleTypeMapper.class);
    private final boolean decimalTypeNarrowing;
    private final boolean handleBlobAsString;

    public OracleTypeMapper() {
        this((Boolean)JdbcCommonOptions.DECIMAL_TYPE_NARROWING.defaultValue(), (Boolean)JdbcCommonOptions.HANDLE_BLOB_AS_STRING.defaultValue());
    }

    public OracleTypeMapper(boolean decimalTypeNarrowing) {
        this(decimalTypeNarrowing, (Boolean)JdbcCommonOptions.HANDLE_BLOB_AS_STRING.defaultValue());
    }

    public OracleTypeMapper(boolean decimalTypeNarrowing, boolean handleBlobAsString) {
        this.decimalTypeNarrowing = decimalTypeNarrowing;
        this.handleBlobAsString = handleBlobAsString;
    }

    @Override
    public Column mappingColumn(BasicTypeDefine typeDefine) {
        return new OracleTypeConverter(this.decimalTypeNarrowing, this.handleBlobAsString).convert(typeDefine);
    }

    @Override
    public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnName = metadata.getColumnLabel(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        long precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        if ("number".equalsIgnoreCase(nativeType) && scale == -127) {
            nativeType = "float";
        } else if (Arrays.asList("NVARCHAR2", "NCHAR").contains(nativeType)) {
            long doubleByteLength;
            precision = doubleByteLength = TypeDefineUtils.charToDoubleByteLength(precision).longValue();
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine);
    }
}

