/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase.OceanBaseMySqlCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase.OceanBaseOracleCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class OceanBaseCatalogFactory
implements CatalogFactory {
    private static final Logger log = LoggerFactory.getLogger(OceanBaseCatalogFactory.class);

    public String factoryIdentifier() {
        return "OceanBase";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCommonOptions.URL);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{urlWithDatabase}), (Object)"Miss config <url>! Please check your config.");
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCommonOptions.URL);
        }
        String compatibleMode = (String)options.get(JdbcCommonOptions.COMPATIBLE_MODE);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{compatibleMode}), (Object)"Miss config <compatible_mode>! Please check your config.");
        if ("oracle".equalsIgnoreCase(compatibleMode.trim())) {
            return new OceanBaseOracleCatalog(catalogName, (String)options.get(JdbcCommonOptions.USERNAME), (String)options.get(JdbcCommonOptions.PASSWORD), urlInfo, (String)options.get(JdbcCommonOptions.SCHEMA), (String)options.get(JdbcCommonOptions.DRIVER));
        }
        return new OceanBaseMySqlCatalog(catalogName, (String)options.get(JdbcCommonOptions.USERNAME), (String)options.get(JdbcCommonOptions.PASSWORD), urlInfo, (String)options.get(JdbcCommonOptions.DRIVER));
    }

    public OptionRule optionRule() {
        return JdbcCommonOptions.BASE_CATALOG_RULE.required(new Option[]{JdbcCommonOptions.COMPATIBLE_MODE}).build();
    }
}

