/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.TiDBSource;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.config.TiDBSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.tidb.TiDBCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.tidb.TiDBCatalogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class TiDBSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(TiDBSourceFactory.class);

    public String factoryIdentifier() {
        return "TiDB-CDC";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{TiDBSourceOptions.DATABASE_NAME, TiDBSourceOptions.TABLE_NAME, TiDBSourceOptions.PD_ADDRESSES}).optional(new Option[]{TiDBSourceOptions.TIKV_BATCH_GET_CONCURRENCY, TiDBSourceOptions.TIKV_BATCH_SCAN_CONCURRENCY, TiDBSourceOptions.TIKV_GRPC_SCAN_TIMEOUT, TiDBSourceOptions.TIKV_GRPC_TIMEOUT, TiDBSourceOptions.STARTUP_MODE}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return TiDBSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (Exception e) {
                log.warn("Failed to load JDBC driver com.mysql.cj.jdbc.Driver ", (Throwable)e);
            }
            ReadonlyConfig config = context.getOptions();
            TiDBCatalogFactory catalogFactory = new TiDBCatalogFactory();
            TiDBCatalog catalog = (TiDBCatalog)catalogFactory.createCatalog(this.factoryIdentifier(), config);
            TablePath tablePath = TablePath.of((String)((String)config.get(TiDBSourceOptions.DATABASE_NAME)), (String)((String)config.get(TiDBSourceOptions.TABLE_NAME)));
            CatalogTable catalogTable = catalog.getTable(tablePath);
            return new TiDBSource(context.getOptions(), catalogTable);
        };
    }
}

