/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split.JdbcNumericBetweenParametersProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.ChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedChunkSplitter
extends ChunkSplitter {
    private static final Logger log = LoggerFactory.getLogger(FixedChunkSplitter.class);

    public FixedChunkSplitter(JdbcSourceConfig config) {
        super(config);
    }

    @Override
    protected Collection<JdbcSourceSplit> createSplits(JdbcSourceTable table, SeaTunnelRowType splitKey) throws SQLException {
        int scale;
        String splitKeyName = splitKey.getFieldNames()[0];
        SeaTunnelDataType splitKeyType = splitKey.getFieldType(0);
        if (splitKeyType instanceof DecimalType && (scale = ((DecimalType)splitKeyType).getScale()) != 0) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("The current field is DecimalType containing decimals: %d Unable to support", scale));
        }
        if (SqlType.STRING.equals((Object)splitKeyType.getSqlType())) {
            return this.createStringColumnSplits(table, splitKeyName, splitKeyType);
        }
        BigDecimal partitionStart = table.getPartitionStart();
        BigDecimal partitionEnd = table.getPartitionEnd();
        if (partitionStart == null || partitionEnd == null) {
            Pair<BigDecimal, BigDecimal> range = this.findSplitColumnRange(table, splitKeyName);
            partitionStart = range.getLeft();
            partitionEnd = range.getRight();
        }
        if (partitionStart == null || partitionEnd == null) {
            JdbcSourceSplit spilt = this.createSingleSplit(table);
            return Collections.singletonList(spilt);
        }
        return this.createNumberColumnSplits(table, splitKeyName, splitKeyType, partitionStart, partitionEnd);
    }

    @Override
    protected PreparedStatement createSplitStatement(JdbcSourceSplit split, TableSchema schema) throws SQLException {
        if (SqlType.STRING.equals((Object)split.getSplitKeyType().getSqlType())) {
            return this.createStringColumnSplitStatement(split);
        }
        if (split.getSplitStart() == null && split.getSplitEnd() == null) {
            return this.createSingleSplitStatement(split);
        }
        return this.createNumberColumnSplitStatement(split);
    }

    private Collection<JdbcSourceSplit> createStringColumnSplits(JdbcSourceTable table, String splitKeyName, SeaTunnelDataType splitKeyType) {
        ArrayList<JdbcSourceSplit> splits = new ArrayList<JdbcSourceSplit>(table.getPartitionNumber());
        Column column = table.getCatalogTable().getTableSchema().getColumns().stream().filter(c -> c.getName().equals(splitKeyName)).findAny().get();
        for (int i = 0; i < table.getPartitionNumber(); ++i) {
            String splitQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT * FROM (%s) st_jdbc_splitter WHERE %s = ?", table.getQuery(), this.jdbcDialect.hashModForField(column.getSourceType(), splitKeyName, table.getPartitionNumber())) : String.format("SELECT * FROM %s WHERE %s = ?", this.jdbcDialect.tableIdentifier(table.getTablePath()), this.jdbcDialect.hashModForField(column.getSourceType(), splitKeyName, table.getPartitionNumber()));
            JdbcSourceSplit split = new JdbcSourceSplit(table.getTablePath(), this.createSplitId(table.getTablePath(), i), splitQuery, splitKeyName, splitKeyType, i, null);
            splits.add(split);
        }
        return splits;
    }

    private PreparedStatement createStringColumnSplitStatement(JdbcSourceSplit split) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(split.getSplitQuery());
        statement.setInt(1, (Integer)split.getSplitStart());
        return statement;
    }

    private Collection<JdbcSourceSplit> createNumberColumnSplits(JdbcSourceTable table, String splitKeyName, SeaTunnelDataType splitKeyType, BigDecimal partitionStart, BigDecimal partitionEnd) {
        JdbcNumericBetweenParametersProvider jdbcNumericBetweenParametersProvider = new JdbcNumericBetweenParametersProvider(partitionStart, partitionEnd).ofBatchNum(table.getPartitionNumber());
        Serializable[][] parameterValues = jdbcNumericBetweenParametersProvider.getParameterValues();
        ArrayList<JdbcSourceSplit> splits = new ArrayList<JdbcSourceSplit>(table.getPartitionNumber());
        for (int i = 0; i < parameterValues.length; ++i) {
            JdbcSourceSplit split = new JdbcSourceSplit(table.getTablePath(), this.createSplitId(table.getTablePath(), i), table.getQuery(), splitKeyName, splitKeyType, parameterValues[i][0], parameterValues[i][1]);
            splits.add(split);
        }
        return splits;
    }

    private PreparedStatement createNumberColumnSplitStatement(JdbcSourceSplit split) throws SQLException {
        String splitKeyName = this.jdbcDialect.quoteIdentifier(split.getSplitKeyName());
        String splitQuery = StringUtils.isNotBlank(split.getSplitQuery()) ? String.format("SELECT * FROM (%s) st_jdbc_splitter WHERE %s >= ? AND %s <= ?", split.getSplitQuery(), splitKeyName, splitKeyName) : String.format("SELECT * FROM %s WHERE %s >= ? AND %s <= ?", this.jdbcDialect.tableIdentifier(split.getTablePath()), splitKeyName, splitKeyName);
        PreparedStatement statement = this.createPreparedStatement(splitQuery);
        Object[] parameterValues = new Object[]{split.getSplitStart(), split.getSplitEnd()};
        for (int i = 0; i < parameterValues.length; ++i) {
            Object param = parameterValues[i];
            if (param instanceof String) {
                statement.setString(i + 1, (String)param);
                continue;
            }
            if (param instanceof Long) {
                statement.setLong(i + 1, (Long)param);
                continue;
            }
            if (param instanceof Integer) {
                statement.setInt(i + 1, (Integer)param);
                continue;
            }
            if (param instanceof Double) {
                statement.setDouble(i + 1, (Double)param);
                continue;
            }
            if (param instanceof Boolean) {
                statement.setBoolean(i + 1, (Boolean)param);
                continue;
            }
            if (param instanceof Float) {
                statement.setFloat(i + 1, ((Float)param).floatValue());
                continue;
            }
            if (param instanceof BigDecimal) {
                statement.setBigDecimal(i + 1, (BigDecimal)param);
                continue;
            }
            if (param instanceof Byte) {
                statement.setByte(i + 1, (Byte)param);
                continue;
            }
            if (param instanceof Short) {
                statement.setShort(i + 1, (Short)param);
                continue;
            }
            if (param instanceof Date) {
                statement.setDate(i + 1, (Date)param);
                continue;
            }
            if (param instanceof Time) {
                statement.setTime(i + 1, (Time)param);
                continue;
            }
            if (param instanceof Timestamp) {
                statement.setTimestamp(i + 1, (Timestamp)param);
                continue;
            }
            if (param instanceof Array) {
                statement.setArray(i + 1, (Array)param);
                continue;
            }
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "open() failed. Parameter " + i + " of type " + param.getClass() + " is not handled (yet).");
        }
        return statement;
    }

    private Pair<BigDecimal, BigDecimal> findSplitColumnRange(JdbcSourceTable table, String columnName) throws SQLException {
        Pair<Object, Object> splitColumnRange = this.queryMinMax(table, columnName);
        Object min2 = splitColumnRange.getLeft();
        Object max = splitColumnRange.getRight();
        if (min2 != null) {
            min2 = this.convertToBigDecimal(min2);
        }
        if (max != null) {
            max = this.convertToBigDecimal(max);
        }
        return Pair.of((BigDecimal)min2, (BigDecimal)max);
    }

    private BigDecimal convertToBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Long) {
            return BigDecimal.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof Integer) {
            return BigDecimal.valueOf(((Integer)o).intValue());
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o);
        }
        if (o instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)o != false ? 1L : 0L);
        }
        if (o instanceof Float) {
            return BigDecimal.valueOf(((Float)o).floatValue());
        }
        if (o instanceof Byte) {
            return BigDecimal.valueOf(((Byte)o).byteValue());
        }
        if (o instanceof Short) {
            return BigDecimal.valueOf(((Short)o).shortValue());
        }
        if (o instanceof Date) {
            return BigDecimal.valueOf(((Date)o).getTime());
        }
        if (o instanceof Time) {
            return BigDecimal.valueOf(((Time)o).getTime());
        }
        if (o instanceof Timestamp) {
            return BigDecimal.valueOf(((Timestamp)o).getTime());
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "convert failed. Column " + o.getClass() + " of type " + o.getClass() + " is not handled (yet).");
    }
}

