/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.tablestore;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablestoreTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(TablestoreTypeMapper.class);
    private static final String TABLESTORE_UNKNOWN = "UNKNOWN";
    private static final String TABLESTORE_BOOL = "BOOL";
    private static final String TABLESTORE_BIGINT = "BIGINT";
    private static final String TABLESTORE_DOUBLE = "DOUBLE";
    private static final String TABLESTORE_VARCHAR = "VARCHAR";
    private static final String TABLESTORE_MEDIUMTEXT = "MEDIUMTEXT";
    private static final String TABLESTORE_VARBINARY = "VARBINARY";
    private static final String TABLESTORE_MEDIUMBLOB = "MEDIUMBLOB";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String tablestoreServerType;
        switch (tablestoreServerType = metadata.getColumnTypeName(colIndex).toUpperCase()) {
            case "BOOL": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "VARCHAR": 
            case "MEDIUMTEXT": {
                return BasicType.STRING_TYPE;
            }
            case "VARBINARY": 
            case "MEDIUMBLOB": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"Tablestore", (String)tablestoreServerType, (String)jdbcColumnName);
    }
}

