/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.SQLUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MySqlTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MysqlJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.MysqlDefaultValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(MysqlDialect.class);
    private static final List NOT_SUPPORTED_DEFAULT_VALUES = Arrays.asList(MysqlType.BLOB, MysqlType.TEXT, MysqlType.JSON, MysqlType.GEOMETRY);
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public MysqlDialect() {
    }

    public MysqlDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "MySQL";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new MysqlJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new MySqlTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return "`" + this.getFieldIde(identifier, this.fieldIde) + "`";
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.tableIdentifier(tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String updateClause = Arrays.stream(fieldNames).map(fieldName -> this.quoteIdentifier((String)fieldName) + "=VALUES(" + this.quoteIdentifier((String)fieldName) + ")").collect(Collectors.joining(", "));
        String upsertSQL = this.getInsertIntoStatement(database, tableName, fieldNames) + " ON DUPLICATE KEY UPDATE " + updateClause;
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        return statement;
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getTableName();
    }

    @Override
    public Map<String, String> defaultParameter() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rewriteBatchedStatements", "true");
        return map;
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)false);
    }

    @Override
    public Object[] sampleDataFromColumn(Connection connection, JdbcSourceTable table, String columnName, int samplingRate, int fetchSize) throws Exception {
        String sampleQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT %s FROM (%s) AS T", this.quoteIdentifier(columnName), table.getQuery()) : String.format("SELECT %s FROM %s", this.quoteIdentifier(columnName), this.tableIdentifier(table.getTablePath()));
        try (Statement stmt = connection.createStatement(1003, 1007);){
            Object[] objectArray;
            block14: {
                stmt.setFetchSize(Integer.MIN_VALUE);
                ResultSet rs = stmt.executeQuery(sampleQuery);
                try {
                    int count = 0;
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (rs.next()) {
                        if (++count % samplingRate == 0) {
                            results.add(rs.getObject(1));
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException("Thread interrupted");
                    }
                    Object[] resultsArray = results.toArray();
                    Arrays.sort(resultsArray);
                    objectArray = resultsArray;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return objectArray;
        }
    }

    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        boolean useTableStats;
        boolean bl = useTableStats = StringUtils.isBlank(table.getQuery()) || !table.getQuery().toLowerCase().contains("where") && table.getTablePath() != null && !TablePath.DEFAULT.getFullName().equals(table.getTablePath().getFullName());
        if (useTableStats) {
            TablePath tablePath = table.getTablePath();
            String useDatabaseStatement = String.format("USE %s;", this.quoteDatabaseIdentifier(tablePath.getDatabaseName()));
            String rowCountQuery = String.format("SHOW TABLE STATUS LIKE '%s';", tablePath.getTableName());
            try (Statement stmt = connection.createStatement();){
                Long l;
                block14: {
                    log.info("Split Chunk, approximateRowCntStatement: {}", (Object)useDatabaseStatement);
                    stmt.execute(useDatabaseStatement);
                    log.info("Split Chunk, approximateRowCntStatement: {}", (Object)rowCountQuery);
                    ResultSet rs = stmt.executeQuery(rowCountQuery);
                    try {
                        if (!rs.next() || rs.getMetaData().getColumnCount() < 5) {
                            throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
                        }
                        l = rs.getLong(5);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return l;
            }
        }
        return SQLUtils.countForSubquery(connection, table.getQuery());
    }

    @Override
    public String decorateWithComment(String basicSql, BasicTypeDefine typeBasicTypeDefine) {
        MysqlType nativeType = (MysqlType)typeBasicTypeDefine.getNativeType();
        if (NOT_SUPPORTED_DEFAULT_VALUES.contains(nativeType)) {
            return basicSql;
        }
        return JdbcDialect.super.decorateWithComment(basicSql, typeBasicTypeDefine);
    }

    @Override
    public boolean needsQuotesWithDefaultValue(String sqlType) {
        MysqlType mysqlType = MysqlType.getByName((String)sqlType);
        switch (mysqlType) {
            case CHAR: 
            case VARCHAR: 
            case TEXT: 
            case TINYTEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case ENUM: 
            case SET: 
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: 
            case TIME: 
            case YEAR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSpecialDefaultValue(Object defaultValue) {
        return MysqlDefaultValueUtils.isSpecialDefaultValue(defaultValue);
    }
}

