/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.gbase8a;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gbase8aTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(Gbase8aTypeMapper.class);
    private static final String GBASE8A_UNKNOWN = "UNKNOWN";
    private static final String GBASE8A_INT = "INT";
    private static final String GBASE8A_TINYINT = "TINYINT";
    private static final String GBASE8A_SMALLINT = "SMALLINT";
    private static final String GBASE8A_BIGINT = "BIGINT";
    private static final String GBASE8A_DECIMAL = "DECIMAL";
    private static final String GBASE8A_FLOAT = "FLOAT";
    private static final String GBASE8A_DOUBLE = "DOUBLE";
    private static final String GBASE8A_CHAR = "CHAR";
    private static final String GBASE8A_VARCHAR = "VARCHAR";
    private static final String GBASE8A_DATE = "DATE";
    private static final String GBASE8A_TIME = "TIME";
    private static final String GBASE8A_TIMESTAMP = "TIMESTAMP";
    private static final String GBASE8A_DATETIME = "DATETIME";
    private static final String GBASE8A_BLOB = "BLOB";
    private static final String GBASE8A_TEXT = "TEXT";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String gbase8aType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (gbase8aType) {
            case "TINYINT": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": {
                if (precision < 38) {
                    return new DecimalType(precision, scale);
                }
                return new DecimalType(38, 18);
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "CHAR": 
            case "VARCHAR": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "BLOB": 
            case "TEXT": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"Gbase8a", (String)gbase8aType, (String)jdbcColumnName);
    }
}

