/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcFieldTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcRowConverter
implements JdbcRowConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcRowConverter.class);
    protected static final String[] TYPE_ARRAY_STRING = new String[0];
    protected static final Boolean[] TYPE_ARRAY_BOOLEAN = new Boolean[0];
    protected static final Byte[] TYPE_ARRAY_BYTE = new Byte[0];
    protected static final Short[] TYPE_ARRAY_SHORT = new Short[0];
    protected static final Integer[] TYPE_ARRAY_INTEGER = new Integer[0];
    protected static final Long[] TYPE_ARRAY_LONG = new Long[0];
    protected static final Float[] TYPE_ARRAY_FLOAT = new Float[0];
    protected static final Double[] TYPE_ARRAY_DOUBLE = new Double[0];
    protected static final BigDecimal[] TYPE_ARRAY_BIG_DECIMAL = new BigDecimal[0];
    protected static final LocalDate[] TYPE_ARRAY_LOCAL_DATE = new LocalDate[0];
    protected static final LocalDateTime[] TYPE_ARRAY_LOCAL_DATETIME = new LocalDateTime[0];

    public abstract String converterName();

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, TableSchema tableSchema) throws SQLException {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block17: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            String fieldName = typeInfo.getFieldName(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getString(rs, resultSetIndex);
                    continue block17;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBoolean(rs, resultSetIndex);
                    continue block17;
                }
                case TINYINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getByte(rs, resultSetIndex);
                    continue block17;
                }
                case SMALLINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getShort(rs, resultSetIndex);
                    continue block17;
                }
                case INT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getInt(rs, resultSetIndex);
                    continue block17;
                }
                case BIGINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getLong(rs, resultSetIndex);
                    continue block17;
                }
                case FLOAT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getFloat(rs, resultSetIndex);
                    continue block17;
                }
                case DOUBLE: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getDouble(rs, resultSetIndex);
                    continue block17;
                }
                case DECIMAL: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBigDecimal(rs, resultSetIndex);
                    continue block17;
                }
                case DATE: {
                    Date sqlDate = JdbcFieldTypeUtils.getDate(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block17;
                }
                case TIME: {
                    fields[fieldIndex] = this.readTime(rs, resultSetIndex);
                    continue block17;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = JdbcFieldTypeUtils.getTimestamp(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block17;
                }
                case BYTES: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBytes(rs, resultSetIndex);
                    continue block17;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block17;
                }
                case ARRAY: {
                    fields[fieldIndex] = this.convertToArray(rs, resultSetIndex, seaTunnelDataType, fieldName);
                    continue block17;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)this.converterName(), (String)seaTunnelDataType.getSqlType().toString(), (String)fieldName);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    protected LocalTime readTime(ResultSet rs, int resultSetIndex) throws SQLException {
        Time sqlTime = JdbcFieldTypeUtils.getTime(rs, resultSetIndex);
        return Optional.ofNullable(sqlTime).map(e -> e.toLocalTime()).orElse(null);
    }

    public Object[] convertToArray(ResultSet rs, int resultSetIndex, SeaTunnelDataType<?> seaTunnelDataType, String fieldName) throws SQLException {
        Array array = rs.getArray(resultSetIndex);
        if (array != null) {
            Object[] elementArr = (Object[])array.getArray();
            List<Object> origArray = Arrays.asList(elementArr);
            SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
            switch (elementType.getSqlType()) {
                case STRING: {
                    return origArray.toArray(TYPE_ARRAY_STRING);
                }
                case BOOLEAN: {
                    return origArray.toArray(TYPE_ARRAY_BOOLEAN);
                }
                case TINYINT: {
                    return origArray.toArray(TYPE_ARRAY_BYTE);
                }
                case SMALLINT: {
                    return origArray.toArray(TYPE_ARRAY_SHORT);
                }
                case INT: {
                    return origArray.toArray(TYPE_ARRAY_INTEGER);
                }
                case BIGINT: {
                    return origArray.toArray(TYPE_ARRAY_LONG);
                }
                case FLOAT: {
                    return origArray.toArray(TYPE_ARRAY_FLOAT);
                }
                case DOUBLE: {
                    return origArray.toArray(TYPE_ARRAY_DOUBLE);
                }
                case DECIMAL: {
                    return origArray.toArray(TYPE_ARRAY_BIG_DECIMAL);
                }
            }
            String type = String.format("Array[%s]", elementType.getSqlType());
            throw CommonError.unsupportedDataType((String)this.converterName(), (String)type, (String)fieldName);
        }
        return null;
    }

    @Override
    public PreparedStatement toExternal(TableSchema tableSchema, SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        SeaTunnelRowType rowType = tableSchema.toPhysicalRowDataType();
        for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            try {
                SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
                int statementIndex = fieldIndex + 1;
                Object fieldValue = row.getField(fieldIndex);
                if (fieldValue == null) {
                    statement.setObject(statementIndex, null);
                    continue;
                }
                switch (seaTunnelDataType.getSqlType()) {
                    case STRING: {
                        statement.setString(statementIndex, (String)row.getField(fieldIndex));
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                        break;
                    }
                    case TINYINT: {
                        statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                        break;
                    }
                    case SMALLINT: {
                        statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                        break;
                    }
                    case INT: {
                        statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                        break;
                    }
                    case BIGINT: {
                        statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                        break;
                    }
                    case FLOAT: {
                        statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                        break;
                    }
                    case DECIMAL: {
                        statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                        break;
                    }
                    case DATE: {
                        LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                        statement.setDate(statementIndex, Date.valueOf(localDate));
                        break;
                    }
                    case TIME: {
                        this.writeTime(statement, statementIndex, (LocalTime)row.getField(fieldIndex));
                        break;
                    }
                    case TIMESTAMP: {
                        LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                        statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                        break;
                    }
                    case BYTES: {
                        statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                        break;
                    }
                    case NULL: {
                        statement.setNull(statementIndex, 0);
                        break;
                    }
                    case ARRAY: {
                        SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
                        Object[] array = (Object[])row.getField(fieldIndex);
                        if (array == null) {
                            statement.setNull(statementIndex, 2003);
                            break;
                        }
                        if (SqlType.TINYINT.equals((Object)elementType.getSqlType())) {
                            Short[] shortArray = new Short[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                shortArray[i] = Short.valueOf(array[i].toString());
                            }
                            statement.setObject(statementIndex, shortArray);
                            break;
                        }
                        statement.setObject(statementIndex, array);
                        break;
                    }
                    default: {
                        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new JdbcConnectorException(JdbcConnectorErrorCode.DATA_TYPE_CAST_FAILED, "error field:" + rowType.getFieldNames()[fieldIndex], e);
            }
        }
        return statement;
    }

    protected void writeTime(PreparedStatement statement, int index, LocalTime time) throws SQLException {
        statement.setTime(index, Time.valueOf(time));
    }
}

