/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;

public class JdbcConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    public String url;
    public String driverName;
    public String compatibleMode;
    public int connectionCheckTimeoutSeconds = (Integer)JdbcOptions.CONNECTION_CHECK_TIMEOUT_SEC.defaultValue();
    public int maxRetries = (Integer)JdbcOptions.MAX_RETRIES.defaultValue();
    public String username;
    public String password;
    public String query;
    public boolean autoCommit = (Boolean)JdbcOptions.AUTO_COMMIT.defaultValue();
    public int batchSize = (Integer)JdbcOptions.BATCH_SIZE.defaultValue();
    public String xaDataSourceClassName;
    public boolean decimalTypeNarrowing = (Boolean)JdbcOptions.DECIMAL_TYPE_NARROWING.defaultValue();
    public int maxCommitAttempts = (Integer)JdbcOptions.MAX_COMMIT_ATTEMPTS.defaultValue();
    public int transactionTimeoutSec = (Integer)JdbcOptions.TRANSACTION_TIMEOUT_SEC.defaultValue();
    public boolean useKerberos = (Boolean)JdbcOptions.USE_KERBEROS.defaultValue();
    public String kerberosPrincipal;
    public String kerberosKeytabPath;
    public String krb5Path = (String)JdbcOptions.KRB5_PATH.defaultValue();
    private Map<String, String> properties;

    public static JdbcConnectionConfig of(ReadonlyConfig config) {
        Builder builder = JdbcConnectionConfig.builder();
        builder.url((String)config.get(JdbcOptions.URL));
        builder.compatibleMode((String)config.get(JdbcOptions.COMPATIBLE_MODE));
        builder.driverName((String)config.get(JdbcOptions.DRIVER));
        builder.autoCommit((Boolean)config.get(JdbcOptions.AUTO_COMMIT));
        builder.maxRetries((Integer)config.get(JdbcOptions.MAX_RETRIES));
        builder.connectionCheckTimeoutSeconds((Integer)config.get(JdbcOptions.CONNECTION_CHECK_TIMEOUT_SEC));
        builder.batchSize((Integer)config.get(JdbcOptions.BATCH_SIZE));
        if (((Boolean)config.get(JdbcOptions.IS_EXACTLY_ONCE)).booleanValue()) {
            builder.xaDataSourceClassName((String)config.get(JdbcOptions.XA_DATA_SOURCE_CLASS_NAME));
            builder.maxCommitAttempts((Integer)config.get(JdbcOptions.MAX_COMMIT_ATTEMPTS));
            builder.transactionTimeoutSec((Integer)config.get(JdbcOptions.TRANSACTION_TIMEOUT_SEC));
            builder.maxRetries(0);
        }
        if (((Boolean)config.get(JdbcOptions.USE_KERBEROS)).booleanValue()) {
            builder.useKerberos((Boolean)config.get(JdbcOptions.USE_KERBEROS));
            builder.kerberosPrincipal((String)config.get(JdbcOptions.KERBEROS_PRINCIPAL));
            builder.kerberosKeytabPath((String)config.get(JdbcOptions.KERBEROS_KEYTAB_PATH));
            builder.krb5Path((String)config.get(JdbcOptions.KRB5_PATH));
        }
        config.getOptional(JdbcOptions.USER).ifPresent(builder::username);
        config.getOptional(JdbcOptions.PASSWORD).ifPresent(builder::password);
        config.getOptional(JdbcOptions.PROPERTIES).ifPresent(builder::properties);
        config.getOptional(JdbcOptions.DECIMAL_TYPE_NARROWING).ifPresent(builder::decimalTypeNarrowing);
        return builder.build();
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getCompatibleMode() {
        return this.compatibleMode;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public int getConnectionCheckTimeoutSeconds() {
        return this.connectionCheckTimeoutSeconds;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isDecimalTypeNarrowing() {
        return this.decimalTypeNarrowing;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public int getMaxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    public Optional<Integer> getTransactionTimeoutSec() {
        return this.transactionTimeoutSec < 0 ? Optional.empty() : Optional.of(this.transactionTimeoutSec);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String url;
        private String driverName;
        private String compatibleMode;
        private int connectionCheckTimeoutSeconds = (Integer)JdbcOptions.CONNECTION_CHECK_TIMEOUT_SEC.defaultValue();
        private int maxRetries = (Integer)JdbcOptions.MAX_RETRIES.defaultValue();
        private String username;
        private String password;
        private String query;
        private boolean autoCommit = (Boolean)JdbcOptions.AUTO_COMMIT.defaultValue();
        private int batchSize = (Integer)JdbcOptions.BATCH_SIZE.defaultValue();
        private String xaDataSourceClassName;
        private boolean decimalTypeNarrowing = (Boolean)JdbcOptions.DECIMAL_TYPE_NARROWING.defaultValue();
        private int maxCommitAttempts = (Integer)JdbcOptions.MAX_COMMIT_ATTEMPTS.defaultValue();
        private int transactionTimeoutSec = (Integer)JdbcOptions.TRANSACTION_TIMEOUT_SEC.defaultValue();
        private Map<String, String> properties;
        public boolean useKerberos = (Boolean)JdbcOptions.USE_KERBEROS.defaultValue();
        public String kerberosPrincipal;
        public String kerberosKeytabPath;
        public String krb5Path = (String)JdbcOptions.KRB5_PATH.defaultValue();

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder compatibleMode(String compatibleMode) {
            this.compatibleMode = compatibleMode;
            return this;
        }

        public Builder connectionCheckTimeoutSeconds(int connectionCheckTimeoutSeconds) {
            this.connectionCheckTimeoutSeconds = connectionCheckTimeoutSeconds;
            return this;
        }

        public Builder decimalTypeNarrowing(boolean decimalTypeNarrowing) {
            this.decimalTypeNarrowing = decimalTypeNarrowing;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder xaDataSourceClassName(String xaDataSourceClassName) {
            this.xaDataSourceClassName = xaDataSourceClassName;
            return this;
        }

        public Builder maxCommitAttempts(int maxCommitAttempts) {
            this.maxCommitAttempts = maxCommitAttempts;
            return this;
        }

        public Builder transactionTimeoutSec(int transactionTimeoutSec) {
            this.transactionTimeoutSec = transactionTimeoutSec;
            return this;
        }

        public Builder useKerberos(boolean useKerberos) {
            this.useKerberos = useKerberos;
            return this;
        }

        public Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public Builder kerberosKeytabPath(String kerberosKeytabPath) {
            this.kerberosKeytabPath = kerberosKeytabPath;
            return this;
        }

        public Builder krb5Path(String krb5Path) {
            this.krb5Path = krb5Path;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public JdbcConnectionConfig build() {
            JdbcConnectionConfig jdbcConnectionConfig = new JdbcConnectionConfig();
            jdbcConnectionConfig.batchSize = this.batchSize;
            jdbcConnectionConfig.driverName = this.driverName;
            jdbcConnectionConfig.compatibleMode = this.compatibleMode;
            jdbcConnectionConfig.maxRetries = this.maxRetries;
            jdbcConnectionConfig.password = this.password;
            jdbcConnectionConfig.connectionCheckTimeoutSeconds = this.connectionCheckTimeoutSeconds;
            jdbcConnectionConfig.url = this.url;
            jdbcConnectionConfig.autoCommit = this.autoCommit;
            jdbcConnectionConfig.username = this.username;
            jdbcConnectionConfig.transactionTimeoutSec = this.transactionTimeoutSec;
            jdbcConnectionConfig.maxCommitAttempts = this.maxCommitAttempts;
            jdbcConnectionConfig.xaDataSourceClassName = this.xaDataSourceClassName;
            jdbcConnectionConfig.decimalTypeNarrowing = this.decimalTypeNarrowing;
            jdbcConnectionConfig.useKerberos = this.useKerberos;
            jdbcConnectionConfig.kerberosPrincipal = this.kerberosPrincipal;
            jdbcConnectionConfig.kerberosKeytabPath = this.kerberosKeytabPath;
            jdbcConnectionConfig.krb5Path = this.krb5Path;
            jdbcConnectionConfig.properties = this.properties == null ? new HashMap() : this.properties;
            return jdbcConnectionConfig;
        }
    }
}

