/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.split.state;

import io.debezium.relational.TableId;
import java.util.Comparator;
import java.util.List;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.split.IncrementalSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.state.SourceSplitStateBase;

public class IncrementalSplitState
extends SourceSplitStateBase {
    private List<TableId> tableIds;
    private Offset startupOffset;
    private Offset stopOffset;
    private Offset maxSnapshotSplitsHighWatermark;
    private volatile boolean enterPureIncrementPhase;

    public IncrementalSplitState(IncrementalSplit split) {
        super(split);
        this.tableIds = split.getTableIds();
        this.startupOffset = split.getStartupOffset();
        this.stopOffset = split.getStopOffset();
        if (split.getCompletedSnapshotSplitInfos().isEmpty()) {
            this.maxSnapshotSplitsHighWatermark = null;
            this.enterPureIncrementPhase = true;
        } else {
            this.maxSnapshotSplitsHighWatermark = split.getCompletedSnapshotSplitInfos().stream().filter(e -> e.getWatermark() != null).max(Comparator.comparing(o -> o.getWatermark().getHighWatermark())).map(e -> e.getWatermark().getHighWatermark()).get();
            this.enterPureIncrementPhase = false;
        }
    }

    @Override
    public IncrementalSplit toSourceSplit() {
        IncrementalSplit incrementalSplit = this.split.asIncrementalSplit();
        return new IncrementalSplit(incrementalSplit.splitId(), this.getTableIds(), this.getStartupOffset(), this.getStopOffset(), incrementalSplit.getCompletedSnapshotSplitInfos());
    }

    public synchronized boolean markEnterPureIncrementPhaseIfNeed(Offset currentRecordPosition) {
        if (this.enterPureIncrementPhase) {
            return false;
        }
        if (currentRecordPosition.isAtOrAfter(this.maxSnapshotSplitsHighWatermark)) {
            this.split.asIncrementalSplit().getCompletedSnapshotSplitInfos().clear();
            this.enterPureIncrementPhase = true;
            return true;
        }
        return false;
    }

    public synchronized boolean autoEnterPureIncrementPhaseIfAllowed() {
        if (!this.enterPureIncrementPhase && this.maxSnapshotSplitsHighWatermark.compareTo(this.startupOffset) == 0) {
            this.split.asIncrementalSplit().getCompletedSnapshotSplitInfos().clear();
            this.enterPureIncrementPhase = true;
            return true;
        }
        return false;
    }

    public List<TableId> getTableIds() {
        return this.tableIds;
    }

    public Offset getStartupOffset() {
        return this.startupOffset;
    }

    public Offset getStopOffset() {
        return this.stopOffset;
    }

    public Offset getMaxSnapshotSplitsHighWatermark() {
        return this.maxSnapshotSplitsHighWatermark;
    }

    public boolean isEnterPureIncrementPhase() {
        return this.enterPureIncrementPhase;
    }

    public void setTableIds(List<TableId> tableIds) {
        this.tableIds = tableIds;
    }

    public void setStartupOffset(Offset startupOffset) {
        this.startupOffset = startupOffset;
    }

    public void setStopOffset(Offset stopOffset) {
        this.stopOffset = stopOffset;
    }

    public void setMaxSnapshotSplitsHighWatermark(Offset maxSnapshotSplitsHighWatermark) {
        this.maxSnapshotSplitsHighWatermark = maxSnapshotSplitsHighWatermark;
    }

    public void setEnterPureIncrementPhase(boolean enterPureIncrementPhase) {
        this.enterPureIncrementPhase = enterPureIncrementPhase;
    }
}

