/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.schema;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.schema.SchemaChangeResolver;
import org.apache.seatunnel.connectors.cdc.base.utils.SourceRecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaChangeResolver
implements SchemaChangeResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaChangeResolver.class);
    protected static final List<String> SUPPORT_DDL = Lists.newArrayList("ALTER TABLE");
    protected JdbcSourceConfig jdbcSourceConfig;

    public AbstractSchemaChangeResolver(JdbcSourceConfig jdbcSourceConfig) {
        this.jdbcSourceConfig = jdbcSourceConfig;
    }

    @Override
    public boolean support(SourceRecord record) {
        String ddl = SourceRecordUtils.getDdl(record);
        Struct value = (Struct)record.value();
        List tableChanges = value.getArray("tableChanges");
        if (tableChanges == null || tableChanges.isEmpty()) {
            log.warn("Ignoring statement for non-captured table {}", (Object)ddl);
            return false;
        }
        return StringUtils.isNotBlank(ddl) && SUPPORT_DDL.stream().map(String::toUpperCase).anyMatch(prefix -> ddl.toUpperCase().contains((CharSequence)prefix));
    }
}

