/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public class JdbcCommonOptions {
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withFallbackKeys(new String[]{"base-url"}).withDescription("url");
    public static final Option<String> DRIVER = Options.key((String)"driver").stringType().noDefaultValue().withDescription("driver");
    public static final Option<String> SCHEMA = Options.key((String)"schema").stringType().noDefaultValue().withDescription("for databases that support the schema parameter, give it priority.");
    public static final Option<Integer> CONNECTION_CHECK_TIMEOUT_SEC = Options.key((String)"connection_check_timeout_sec").intType().defaultValue((Object)30).withDescription("connection check time second");
    public static final Option<String> COMPATIBLE_MODE = Options.key((String)"compatible_mode").stringType().noDefaultValue().withFallbackKeys(new String[]{"compatibleMode"}).withDescription("The compatible mode of database, required when the database supports multiple compatible modes. For example, when using OceanBase database, you need to set it to 'mysql' or 'oracle'.");
    public static final Option<String> DIALECT = Options.key((String)"dialect").stringType().noDefaultValue().withDescription("The appointed dialect, if it does not exist, is still obtained according to the url");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withFallbackKeys(new String[]{"user"}).withDescription("user");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("password");
    public static final Option<String> QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("query");
    public static final Option<Boolean> DECIMAL_TYPE_NARROWING = Options.key((String)"decimal_type_narrowing").booleanType().defaultValue((Object)true).withDescription("decimal type narrowing, if true, the decimal type will be narrowed to the int or long type if without loss of precision. Only support for Oracle at now.");
    public static final Option<Boolean> INT_TYPE_NARROWING = Options.key((String)"int_type_narrowing").booleanType().defaultValue((Object)true).withDescription("int type narrowing, if true, the tinyint(1) type will be narrowed to the boolean type if without loss of precision. Support for MySQL at now.");
    public static final Option<Boolean> HANDLE_BLOB_AS_STRING = Options.key((String)"handle_blob_as_string").booleanType().defaultValue((Object)false).withDescription("If true, BLOB type will be converted to STRING type. Only support for Oracle at now.");
    public static final Option<Boolean> USE_KERBEROS = Options.key((String)"use_kerberos").booleanType().defaultValue((Object)false).withDescription("Whether to enable Kerberos, default is false.");
    public static final Option<String> KERBEROS_PRINCIPAL = Options.key((String)"kerberos_principal").stringType().noDefaultValue().withDescription("When use kerberos, we should set kerberos principal such as 'test_user@xxx'.");
    public static final Option<String> KERBEROS_KEYTAB_PATH = Options.key((String)"kerberos_keytab_path").stringType().noDefaultValue().withDescription("When use kerberos, we should set kerberos principal file path such as '/home/test/test_user.keytab'.");
    public static final Option<String> KRB5_PATH = Options.key((String)"krb5_path").stringType().defaultValue((Object)"/etc/krb5.conf").withDescription("When use kerberos, we should set krb5 path file path such as '/seatunnel/krb5.conf' or use the default path '/etc/krb5.conf");
    public static final Option<Map<String, String>> PROPERTIES = Options.key((String)"properties").mapType().noDefaultValue().withDescription("additional connection configuration parameters");
    public static final OptionRule.Builder BASE_CATALOG_RULE = OptionRule.builder().required(new Option[]{URL}).required(new Option[]{USERNAME, PASSWORD}).optional(new Option[]{SCHEMA, DECIMAL_TYPE_NARROWING, HANDLE_BLOB_AS_STRING});
}

