/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;

public class SqlServerURLParser {
    private static final int DEFAULT_PORT = 1433;

    public static JdbcUrlUtil.UrlInfo parse(String url) {
        String urlWithoutDatabase;
        int instanceLoc;
        int portLoc;
        String urlServerName;
        String serverName = "";
        Integer port = null;
        String dbInstance = null;
        String instanceName = null;
        int hostIndex = url.indexOf("://");
        if (hostIndex <= 0) {
            return null;
        }
        Map<Object, Object> props = Collections.emptyMap();
        String[] split = url.split(";", 2);
        if (split.length > 1) {
            props = SqlServerURLParser.parseQueryParams(split[1], ";");
            Map<String, String> propsWithUpperCaseKey = props.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), Map.Entry::getValue));
            serverName = propsWithUpperCaseKey.get("SERVERNAME");
            instanceName = propsWithUpperCaseKey.get("INSTANCENAME");
            dbInstance = propsWithUpperCaseKey.getOrDefault("DATABASENAME", (String)props.get("DATABASE"));
            if (propsWithUpperCaseKey.containsKey("PORTNUMBER") || propsWithUpperCaseKey.containsKey("PORT")) {
                String portNumber = propsWithUpperCaseKey.get("PORTNUMBER") == null ? propsWithUpperCaseKey.get("PORT") : propsWithUpperCaseKey.get("PORTNUMBER");
                try {
                    port = Integer.parseInt(portNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!(urlServerName = split[0].substring(hostIndex + 3)).isEmpty()) {
            serverName = urlServerName;
        }
        if ((portLoc = serverName.indexOf(":")) > 1) {
            port = Integer.parseInt(serverName.substring(portLoc + 1));
            serverName = serverName.substring(0, portLoc);
        }
        if ((instanceLoc = serverName.indexOf("\\")) > 1) {
            String[] splitForInstance = serverName.split("\\\\");
            serverName = splitForInstance[0];
            instanceName = splitForInstance[1];
        }
        if (serverName.isEmpty()) {
            return null;
        }
        String suffix = props.entrySet().stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase("databaseName") && !((String)e.getKey()).equalsIgnoreCase("database")).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";", "", ""));
        suffix = Optional.ofNullable(suffix).orElse("");
        if (port != null) {
            urlWithoutDatabase = String.format("jdbc:sqlserver://%s:%s", serverName, port) + ";" + suffix;
        } else if (instanceName != null) {
            urlWithoutDatabase = String.format("jdbc:sqlserver://%s\\%s", serverName, instanceName) + ";" + suffix;
        } else {
            port = 1433;
            urlWithoutDatabase = String.format("jdbc:sqlserver://%s:%s", serverName, port) + ";" + suffix;
        }
        return new JdbcUrlUtil.UrlInfo(url, urlWithoutDatabase, serverName, port, dbInstance, suffix);
    }

    private static Map<String, String> parseQueryParams(String query, String separator) {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split(separator)) {
            try {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()) : pair;
                if (queryParams.containsKey(key)) continue;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()) : null;
                queryParams.put(key, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return queryParams;
    }
}

