/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.config;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class CassandraParameters
implements Serializable {
    private String host;
    private String username;
    private String password;
    private String datacenter;
    private String keyspace;
    private String table;
    private String cql;
    private List<String> fields;
    private ConsistencyLevel consistencyLevel;
    private Integer batchSize;
    private DefaultBatchType batchType;
    private Boolean asyncWrite;

    public void buildWithConfig(Config config) {
        this.host = config.getString(CassandraConfig.HOST.key());
        this.keyspace = config.getString(CassandraConfig.KEYSPACE.key());
        if (config.hasPath(CassandraConfig.USERNAME.key())) {
            this.username = config.getString(CassandraConfig.USERNAME.key());
        }
        if (config.hasPath(CassandraConfig.PASSWORD.key())) {
            this.password = config.getString(CassandraConfig.PASSWORD.key());
        }
        this.datacenter = config.hasPath(CassandraConfig.DATACENTER.key()) ? config.getString(CassandraConfig.DATACENTER.key()) : (String)CassandraConfig.DATACENTER.defaultValue();
        if (config.hasPath(CassandraConfig.TABLE.key())) {
            this.table = config.getString(CassandraConfig.TABLE.key());
        }
        if (config.hasPath(CassandraConfig.CQL.key())) {
            this.cql = config.getString(CassandraConfig.CQL.key());
        }
        if (config.hasPath(CassandraConfig.FIELDS.key())) {
            this.fields = config.getStringList(CassandraConfig.FIELDS.key());
        }
        this.consistencyLevel = config.hasPath(CassandraConfig.CONSISTENCY_LEVEL.key()) ? DefaultConsistencyLevel.valueOf(config.getString(CassandraConfig.CONSISTENCY_LEVEL.key())) : DefaultConsistencyLevel.valueOf((String)CassandraConfig.CONSISTENCY_LEVEL.defaultValue());
        this.batchSize = config.hasPath(CassandraConfig.BATCH_SIZE.key()) ? Integer.valueOf(config.getInt(CassandraConfig.BATCH_SIZE.key())) : (Integer)CassandraConfig.BATCH_SIZE.defaultValue();
        this.batchType = config.hasPath(CassandraConfig.BATCH_TYPE.key()) ? DefaultBatchType.valueOf(config.getString(CassandraConfig.BATCH_TYPE.key())) : DefaultBatchType.valueOf((String)CassandraConfig.BATCH_TYPE.defaultValue());
        this.asyncWrite = config.hasPath(CassandraConfig.ASYNC_WRITE.key()) ? Boolean.valueOf(config.getBoolean(CassandraConfig.ASYNC_WRITE.key())) : Boolean.valueOf(true);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchType(DefaultBatchType batchType) {
        this.batchType = batchType;
    }

    public void setAsyncWrite(Boolean asyncWrite) {
        this.asyncWrite = asyncWrite;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public String getCql() {
        return this.cql;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public DefaultBatchType getBatchType() {
        return this.batchType;
    }

    public Boolean getAsyncWrite() {
        return this.asyncWrite;
    }
}

