/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class HdrReservoir
implements Reservoir {
    private static final Logger LOG = LoggerFactory.getLogger(HdrReservoir.class);
    private final String logPrefix;
    private final Recorder recorder;
    private final long refreshIntervalNanos;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    @GuardedBy(value="cacheLock")
    private Histogram cachedHistogram;
    @GuardedBy(value="cacheLock")
    private long cachedHistogramTimestampNanos;
    @GuardedBy(value="cacheLock")
    private Snapshot cachedSnapshot;
    private static final Snapshot EMPTY_SNAPSHOT = new Snapshot(){

        @Override
        public double getValue(double quantile) {
            return 0.0;
        }

        @Override
        public long[] getValues() {
            return new long[0];
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public long getMax() {
            return 0L;
        }

        @Override
        public double getMean() {
            return 0.0;
        }

        @Override
        public long getMin() {
            return 0L;
        }

        @Override
        public double getStdDev() {
            return 0.0;
        }

        @Override
        public void dump(OutputStream output) {
        }
    };

    public HdrReservoir(Duration highestTrackableLatency, int numberOfSignificantValueDigits, Duration refreshInterval, String logPrefix) {
        this.logPrefix = logPrefix;
        this.recorder = new Recorder(highestTrackableLatency.toNanos() / 1000L, numberOfSignificantValueDigits);
        this.refreshIntervalNanos = refreshInterval.toNanos();
        this.cachedHistogramTimestampNanos = System.nanoTime();
        this.cachedSnapshot = EMPTY_SNAPSHOT;
    }

    @Override
    public void update(long value) {
        try {
            this.recorder.recordValue(value / 1000L);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.warn("[{}] Recorded value ({}) is out of bounds, discarding", (Object)this.logPrefix, (Object)value);
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("HdrReservoir does not implement size()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot getSnapshot() {
        long now = System.nanoTime();
        this.cacheLock.readLock().lock();
        try {
            if (now - this.cachedHistogramTimestampNanos < this.refreshIntervalNanos) {
                Snapshot snapshot = this.cachedSnapshot;
                return snapshot;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        this.cacheLock.writeLock().lock();
        try {
            if (now - this.cachedHistogramTimestampNanos >= this.refreshIntervalNanos) {
                LOG.debug("Cached snapshot is too old, refreshing");
                this.cachedHistogram = this.recorder.getIntervalHistogram(this.cachedHistogram);
                this.cachedSnapshot = new HdrSnapshot(this.cachedHistogram);
                this.cachedHistogramTimestampNanos = now;
            }
            Snapshot snapshot = this.cachedSnapshot;
            return snapshot;
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private class HdrSnapshot
    extends Snapshot {
        private final Histogram histogram;
        private final double meanNanos;
        private final double stdDevNanos;

        private HdrSnapshot(Histogram histogram) {
            this.histogram = histogram;
            this.meanNanos = histogram.getMean() * 1000.0;
            this.stdDevNanos = histogram.getStdDeviation() * 1000.0;
        }

        @Override
        public double getValue(double quantile) {
            return this.histogram.getValueAtPercentile(quantile * 100.0) * 1000L;
        }

        @Override
        public long[] getValues() {
            throw new UnsupportedOperationException("HdrReservoir's snapshots do not implement getValues()");
        }

        @Override
        public int size() {
            int size;
            long longSize = this.histogram.getTotalCount();
            if (longSize > Integer.MAX_VALUE) {
                LOG.warn("[{}] Too many recorded values, truncating", (Object)HdrReservoir.this.logPrefix);
                size = Integer.MAX_VALUE;
            } else {
                size = (int)longSize;
            }
            return size;
        }

        @Override
        public long getMax() {
            return this.histogram.getMaxValue() * 1000L;
        }

        @Override
        public double getMean() {
            return this.meanNanos;
        }

        @Override
        public long getMin() {
            return this.histogram.getMinValue() * 1000L;
        }

        @Override
        public double getStdDev() {
            return this.stdDevNanos;
        }

        @Override
        public void dump(OutputStream output) {
            throw new UnsupportedOperationException("HdrReservoir's snapshots do not implement dump()");
        }
    }
}

