/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface KeyspaceMetadata
extends Describable {
    @NonNull
    public CqlIdentifier getName();

    public boolean isDurableWrites();

    public boolean isVirtual();

    @NonNull
    public Map<String, String> getReplication();

    @NonNull
    public Map<CqlIdentifier, TableMetadata> getTables();

    @NonNull
    default public Optional<TableMetadata> getTable(@NonNull CqlIdentifier tableId) {
        return Optional.ofNullable(this.getTables().get(tableId));
    }

    @NonNull
    default public Optional<TableMetadata> getTable(@NonNull String tableName) {
        return this.getTable(CqlIdentifier.fromCql(tableName));
    }

    @NonNull
    public Map<CqlIdentifier, ViewMetadata> getViews();

    @NonNull
    default public Map<CqlIdentifier, ViewMetadata> getViewsOnTable(@NonNull CqlIdentifier tableId) {
        ImmutableMap.Builder<CqlIdentifier, ViewMetadata> builder = ImmutableMap.builder();
        for (ViewMetadata view : this.getViews().values()) {
            if (!view.getBaseTable().equals(tableId)) continue;
            builder.put(view.getName(), view);
        }
        return builder.build();
    }

    @NonNull
    default public Optional<ViewMetadata> getView(@NonNull CqlIdentifier viewId) {
        return Optional.ofNullable(this.getViews().get(viewId));
    }

    @NonNull
    default public Optional<ViewMetadata> getView(@NonNull String viewName) {
        return this.getView(CqlIdentifier.fromCql(viewName));
    }

    @NonNull
    public Map<CqlIdentifier, UserDefinedType> getUserDefinedTypes();

    @NonNull
    default public Optional<UserDefinedType> getUserDefinedType(@NonNull CqlIdentifier typeId) {
        return Optional.ofNullable(this.getUserDefinedTypes().get(typeId));
    }

    @NonNull
    default public Optional<UserDefinedType> getUserDefinedType(@NonNull String typeName) {
        return this.getUserDefinedType(CqlIdentifier.fromCql(typeName));
    }

    @NonNull
    public Map<FunctionSignature, FunctionMetadata> getFunctions();

    @NonNull
    default public Optional<FunctionMetadata> getFunction(@NonNull FunctionSignature functionSignature) {
        return Optional.ofNullable(this.getFunctions().get(functionSignature));
    }

    @NonNull
    default public Optional<FunctionMetadata> getFunction(@NonNull CqlIdentifier functionId, @NonNull Iterable<DataType> parameterTypes) {
        return Optional.ofNullable(this.getFunctions().get(new FunctionSignature(functionId, parameterTypes)));
    }

    @NonNull
    default public Optional<FunctionMetadata> getFunction(@NonNull String functionName, @NonNull Iterable<DataType> parameterTypes) {
        return this.getFunction(CqlIdentifier.fromCql(functionName), parameterTypes);
    }

    @NonNull
    default public Optional<FunctionMetadata> getFunction(@NonNull CqlIdentifier functionId, DataType ... parameterTypes) {
        return Optional.ofNullable(this.getFunctions().get(new FunctionSignature(functionId, parameterTypes)));
    }

    @NonNull
    default public Optional<FunctionMetadata> getFunction(@NonNull String functionName, DataType ... parameterTypes) {
        return this.getFunction(CqlIdentifier.fromCql(functionName), parameterTypes);
    }

    @NonNull
    public Map<FunctionSignature, AggregateMetadata> getAggregates();

    @NonNull
    default public Optional<AggregateMetadata> getAggregate(@NonNull FunctionSignature aggregateSignature) {
        return Optional.ofNullable(this.getAggregates().get(aggregateSignature));
    }

    @NonNull
    default public Optional<AggregateMetadata> getAggregate(@NonNull CqlIdentifier aggregateId, @NonNull Iterable<DataType> parameterTypes) {
        return Optional.ofNullable(this.getAggregates().get(new FunctionSignature(aggregateId, parameterTypes)));
    }

    @NonNull
    default public Optional<AggregateMetadata> getAggregate(@NonNull String aggregateName, @NonNull Iterable<DataType> parameterTypes) {
        return this.getAggregate(CqlIdentifier.fromCql(aggregateName), parameterTypes);
    }

    @NonNull
    default public Optional<AggregateMetadata> getAggregate(@NonNull CqlIdentifier aggregateId, DataType ... parameterTypes) {
        return Optional.ofNullable(this.getAggregates().get(new FunctionSignature(aggregateId, parameterTypes)));
    }

    @NonNull
    default public Optional<AggregateMetadata> getAggregate(@NonNull String aggregateName, DataType ... parameterTypes) {
        return this.getAggregate(CqlIdentifier.fromCql(aggregateName), parameterTypes);
    }

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        if (this.isVirtual()) {
            builder.append("/* VIRTUAL ");
        } else {
            builder.append("CREATE ");
        }
        builder.append("KEYSPACE ").append(this.getName()).append(" WITH replication = { 'class' : '").append(this.getReplication().get("class")).append("'");
        for (Map.Entry<String, String> entry : this.getReplication().entrySet()) {
            if (entry.getKey().equals("class")) continue;
            builder.append(", '").append(entry.getKey()).append("': '").append(entry.getValue()).append("'");
        }
        builder.append(" } AND durable_writes = ").append(Boolean.toString(this.isDurableWrites())).append(";");
        if (this.isVirtual()) {
            builder.append(" */");
        }
        return builder.build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        String createKeyspace = this.describe(pretty);
        ScriptBuilder builder = new ScriptBuilder(pretty).append(createKeyspace);
        for (Describable element : Iterables.concat(this.getUserDefinedTypes().values(), this.getTables().values(), this.getViews().values(), this.getFunctions().values(), this.getAggregates().values())) {
            builder.forceNewLine(2).append(element.describeWithChildren(pretty));
        }
        return builder.build();
    }

    default public boolean shallowEquals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof KeyspaceMetadata) {
            KeyspaceMetadata that = (KeyspaceMetadata)other;
            return Objects.equals(this.getName(), that.getName()) && this.isDurableWrites() == that.isDurableWrites() && Objects.equals(this.getReplication(), that.getReplication());
        }
        return false;
    }
}

