/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cassandra.source.CassandraSource;

@AutoService(value={Factory.class})
public class CassandraSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Cassandra";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{CassandraSourceOptions.HOST, CassandraSourceOptions.KEYSPACE, CassandraSourceOptions.CQL}).bundled(new Option[]{CassandraSourceOptions.USERNAME, CassandraSourceOptions.PASSWORD}).optional(new Option[]{CassandraSourceOptions.DATACENTER, CassandraSourceOptions.CONSISTENCY_LEVEL}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        CassandraParameters cassandraParameters = new CassandraParameters();
        cassandraParameters.buildWithConfig(context.getOptions());
        return () -> new CassandraSource(cassandraParameters, context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return CassandraSource.class;
    }
}

