/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class Murmur3Token
implements Token {
    private final long value;

    public Murmur3Token(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Murmur3Token) {
            Murmur3Token that = (Murmur3Token)other;
            return this.value == that.value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(@NonNull Token other) {
        Preconditions.checkArgument(other instanceof Murmur3Token, "Can only compare tokens of the same type");
        Murmur3Token that = (Murmur3Token)other;
        return Longs.compare(this.value, that.value);
    }

    public String toString() {
        return "Murmur3Token(" + this.value + ")";
    }
}

