/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertCatalogTableRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertRuleParser;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertTableRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertConfig;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.shade.com.google.common.base.Throwables;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigException;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;

public class AssertSink
extends AbstractSimpleSink<SeaTunnelRow, Void>
implements SupportMultiTableSink {
    private final SeaTunnelRowType seaTunnelRowType;
    private final Map<String, List<AssertFieldRule>> assertFieldRules;
    private final Map<String, List<AssertFieldRule.AssertRule>> assertRowRules;
    private final AssertTableRule assertTableRule;
    private final Map<String, AssertCatalogTableRule> assertCatalogTableRule;
    private final String catalogTableName;
    private final CatalogTable catalogTable;

    public AssertSink(ReadonlyConfig pluginConfig, CatalogTable catalogTable) {
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        if (!pluginConfig.getOptional(AssertConfig.RULES).isPresent()) {
            Throwables.throwIfUnchecked((Throwable)new ConfigException.Missing(AssertConfig.RULES.key()));
        }
        this.assertFieldRules = new ConcurrentHashMap<String, List<AssertFieldRule>>();
        this.assertRowRules = new ConcurrentHashMap<String, List<AssertFieldRule.AssertRule>>();
        this.assertCatalogTableRule = new ConcurrentHashMap<String, AssertCatalogTableRule>();
        this.catalogTableName = catalogTable.getTablePath().getFullName();
        Config ruleConfig = ConfigFactory.parseMap((Map)((Map)pluginConfig.get(AssertConfig.RULES)));
        if (ruleConfig.hasPath(TableSchemaOptions.TABLE_CONFIGS.key())) {
            List tableConfigs = ruleConfig.getConfigList(TableSchemaOptions.TABLE_CONFIGS.key());
            for (Config tableConfig : tableConfigs) {
                String tableName = tableConfig.getString(AssertConfig.TABLE_PATH.key());
                this.initTableRule(catalogTable, tableConfig, tableName);
            }
        } else {
            String tableName = catalogTable.getTablePath().getFullName();
            this.initTableRule(catalogTable, ruleConfig, tableName);
        }
        this.assertTableRule = ruleConfig.hasPath(CatalogOptions.TABLE_NAMES.key()) ? new AssertTableRule(ruleConfig.getStringList(CatalogOptions.TABLE_NAMES.key())) : new AssertTableRule(new ArrayList<String>());
        if (this.assertRowRules.isEmpty() && this.assertFieldRules.isEmpty() && this.assertCatalogTableRule.isEmpty() && this.assertTableRule.getTableNames().isEmpty()) {
            Throwables.throwIfUnchecked((Throwable)new ConfigException.BadValue(AssertConfig.RULES.key(), "Assert rule config is empty, please add rule config."));
        }
        this.catalogTable = catalogTable;
    }

    private void initTableRule(CatalogTable catalogTable, Config tableConfig, String tableName) {
        if (tableConfig.hasPath("row_rules")) {
            List rowConfigList = tableConfig.getConfigList("row_rules");
            this.assertRowRules.put(tableName, new AssertRuleParser().parseRowRules(rowConfigList));
        }
        if (tableConfig.hasPath("field_rules")) {
            List configList = tableConfig.getConfigList("field_rules");
            this.assertFieldRules.put(tableName, new AssertRuleParser().parseRules(configList));
        }
        if (tableConfig.hasPath("catalog_table_rule")) {
            AssertCatalogTableRule catalogTableRule = new AssertRuleParser().parseCatalogTableRule(tableConfig.getConfig("catalog_table_rule"));
            if (tableName.equals(this.catalogTableName)) {
                catalogTableRule.checkRule(catalogTable);
            }
            this.assertCatalogTableRule.put(tableName, catalogTableRule);
        }
    }

    @Override
    public AssertSinkWriter createWriter(SinkWriter.Context context) {
        return new AssertSinkWriter(this.seaTunnelRowType, this.assertFieldRules, this.assertRowRules, this.assertTableRule, this.catalogTableName);
    }

    public String getPluginName() {
        return "Assert";
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.of(this.catalogTable);
    }
}

