/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.rule;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertCatalogTableRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class AssertCatalogTableRuleParser {
    public AssertCatalogTableRule parseCatalogTableRule(Config catalogTableRule) {
        AssertCatalogTableRule tableRule = new AssertCatalogTableRule();
        this.parsePrimaryKeyRule(catalogTableRule).ifPresent(tableRule::setPrimaryKeyRule);
        this.parseConstraintKeyRule(catalogTableRule).ifPresent(tableRule::setConstraintKeyRule);
        this.parseColumnRule(catalogTableRule).ifPresent(tableRule::setColumnRule);
        this.parseTableIdentifierRule(catalogTableRule).ifPresent(tableRule::setTableIdentifierRule);
        return tableRule;
    }

    private Optional<AssertCatalogTableRule.AssertPrimaryKeyRule> parsePrimaryKeyRule(Config catalogTableRule) {
        if (!catalogTableRule.hasPath("primary_key_rule")) {
            return Optional.empty();
        }
        Config primaryKey = catalogTableRule.getConfig("primary_key_rule");
        return Optional.of(new AssertCatalogTableRule.AssertPrimaryKeyRule(primaryKey.getString("primary_key_name"), primaryKey.getStringList("primary_key_columns")));
    }

    private Optional<AssertCatalogTableRule.AssertColumnRule> parseColumnRule(Config catalogTableRule) {
        if (!catalogTableRule.hasPath("column_rule")) {
            return Optional.empty();
        }
        List<Column> columns = catalogTableRule.getConfigList("column_rule").stream().map(config -> {
            String name = config.getString("name");
            String type = config.getString("type");
            Long columnLength = (Long)TypesafeConfigUtils.getConfig((Config)config, (String)"column_length", (Object)TableSchemaOptions.ColumnOptions.COLUMN_LENGTH.defaultValue());
            Boolean nullable = (Boolean)TypesafeConfigUtils.getConfig((Config)config, (String)"nullable", (Object)TableSchemaOptions.ColumnOptions.NULLABLE.defaultValue());
            Object object = TypesafeConfigUtils.getConfig((Config)config, (String)"default_value", (Object)TableSchemaOptions.ColumnOptions.DEFAULT_VALUE.defaultValue());
            String comment = (String)TypesafeConfigUtils.getConfig((Config)config, (String)"comment", (Object)TableSchemaOptions.ColumnOptions.COMMENT.defaultValue());
            return PhysicalColumn.of((String)name, (SeaTunnelDataType)SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType((String)name, (String)type), (Long)columnLength, (boolean)nullable, (Object)object, (String)comment);
        }).collect(Collectors.toList());
        return Optional.of(new AssertCatalogTableRule.AssertColumnRule(columns));
    }

    private Optional<AssertCatalogTableRule.AssertConstraintKeyRule> parseConstraintKeyRule(Config catalogTableRule) {
        if (!catalogTableRule.hasPath("constraint_key_rule")) {
            return Optional.empty();
        }
        List constraintKey = catalogTableRule.getConfigList("constraint_key_rule");
        List<ConstraintKey> constraintKeys = constraintKey.stream().map(config -> {
            ConstraintKey.ConstraintType constraintType = ConstraintKey.ConstraintType.valueOf((String)config.getString("constraint_key_type"));
            String constraintKeyName = config.getString("constraint_key_name");
            List constraintKeyColumns = config.getConfigList("constraint_key_columns").stream().map(c -> ConstraintKey.ConstraintKeyColumn.of((String)c.getString("constraint_key_column_name"), (ConstraintKey.ColumnSortType)ConstraintKey.ColumnSortType.valueOf((String)c.getString("constraint_key_sort_type")))).collect(Collectors.toList());
            return ConstraintKey.of((ConstraintKey.ConstraintType)constraintType, (String)constraintKeyName, constraintKeyColumns);
        }).collect(Collectors.toList());
        return Optional.of(new AssertCatalogTableRule.AssertConstraintKeyRule(constraintKeys));
    }

    private Optional<AssertCatalogTableRule.AssertTableIdentifierRule> parseTableIdentifierRule(Config catalogTableRule) {
        if (!catalogTableRule.hasPath("table_identifier_rule")) {
            return Optional.empty();
        }
        Config tableIdentifierRule = catalogTableRule.getConfig("table_identifier_rule");
        TableIdentifier tableIdentifier = TableIdentifier.of((String)tableIdentifierRule.getString("catalog_name"), (TablePath)TablePath.of((String)tableIdentifierRule.getString("table")));
        return Optional.of(new AssertCatalogTableRule.AssertTableIdentifierRule(tableIdentifier));
    }
}

