/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.activemq.sink;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.activemq.client.ActivemqClient;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class ActivemqSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private ActivemqClient activeMQClient;
    private final SerializationSchema serializationSchema;

    public ActivemqSinkWriter(ReadonlyConfig config, SeaTunnelRowType seaTunnelRowType) {
        this.activeMQClient = new ActivemqClient(config);
        this.serializationSchema = new JsonSerializationSchema(seaTunnelRowType);
    }

    public void write(SeaTunnelRow element) {
        this.activeMQClient.write(this.serializationSchema.serialize(element));
    }

    public void close() {
        if (this.activeMQClient != null) {
            this.activeMQClient.close();
        }
    }
}

