/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.storage;

import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import org.apache.rocketmq.schema.registry.common.context.StoragePluginContext;
import org.apache.rocketmq.schema.registry.common.model.PluginLoadState;
import org.apache.rocketmq.schema.registry.common.model.SchemaInfo;
import org.apache.rocketmq.schema.registry.common.properties.GlobalConfig;
import org.apache.rocketmq.schema.registry.common.storage.StorageFactory;
import org.apache.rocketmq.schema.registry.common.storage.StoragePlugin;
import org.apache.rocketmq.schema.registry.common.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class StorageManager {
    private static final Logger log = LoggerFactory.getLogger(StorageManager.class);
    private final GlobalConfig config;
    private StoragePlugin plugin;
    private StorageFactory factory;
    private final AtomicReference<PluginLoadState> state = new AtomicReference<PluginLoadState>(PluginLoadState.INIT);
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public StorageManager(GlobalConfig config) {
        this.config = config;
    }

    public StorageService<SchemaInfo> getStorageService() {
        return this.factory.getStorageService();
    }

    public void loadPlugin() {
        if (!this.state.compareAndSet(PluginLoadState.INIT, PluginLoadState.LOADING)) {
            return;
        }
        ServiceLoader<StoragePlugin> serviceLoader = ServiceLoader.load(StoragePlugin.class, this.getClass().getClassLoader());
        for (StoragePlugin storagePlugin : serviceLoader) {
            if (!this.config.getStorageType().equals((Object)storagePlugin.getType())) continue;
            log.info("Loading plugin {}", (Object)storagePlugin.getClass().getName());
            this.plugin = storagePlugin;
            log.info("Finished loading plugin {}", (Object)storagePlugin.getClass().getName());
        }
        this.state.set(PluginLoadState.LOADED);
    }

    public void start(ApplicationContext context) {
        if (!this.state.compareAndSet(PluginLoadState.LOADED, PluginLoadState.STARTING)) {
            return;
        }
        StoragePluginContext pluginContext = new StoragePluginContext(this.config);
        if (this.plugin != null) {
            this.factory = this.plugin.load(pluginContext);
            log.info("factory is loading" + this.factory);
        } else {
            log.warn("No plugin for storage with type {}", (Object)pluginContext.getConfig().getStorageType());
        }
        this.state.set(PluginLoadState.STARTED);
    }

    @PreDestroy
    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        try {
            this.factory.stop();
        }
        catch (Exception e) {
            log.error("Error shutting down storage: {}", (Object)this.factory.getStorageType(), (Object)e);
        }
    }

    public boolean isPluginLoaded() {
        return this.state.get().equals((Object)PluginLoadState.LOADED);
    }

    public boolean isConnected() {
        return this.connected.get();
    }
}

