/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.properties;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.model.StorageType;
import org.apache.rocketmq.schema.registry.common.properties.GlobalConfig;
import org.apache.rocketmq.schema.registry.common.properties.SchemaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfigImpl
implements GlobalConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigImpl.class);
    private final SchemaProperties schemaProperties;

    public GlobalConfigImpl(@Nonnull @NonNull SchemaProperties schemaProperties) {
        if (schemaProperties == null) {
            throw new NullPointerException("schemaProperties is marked non-null but is null");
        }
        this.schemaProperties = schemaProperties;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.schemaProperties.getCache().isEnabled();
    }

    @Override
    public boolean isUploadEnabled() {
        return this.schemaProperties.getDependency().isUploadEnabled();
    }

    @Override
    public String getDependencyCompilePath() {
        return this.schemaProperties.getDependency().getCompilePath();
    }

    @Override
    public String getDependencyLocalRepositoryPath() {
        return this.schemaProperties.getDependency().getLocalRepositoryPath();
    }

    @Override
    public String getDependencyJdkPath() {
        return this.schemaProperties.getDependency().getJdkPath();
    }

    @Override
    public String getDependencyRepositoryUrl() {
        return this.schemaProperties.getDependency().getRepositoryUrl();
    }

    @Override
    public String getDependencyUsername() {
        return this.schemaProperties.getDependency().getUsername();
    }

    @Override
    public String getDependencyPassword() {
        return this.schemaProperties.getDependency().getPassword();
    }

    @Override
    public String getDependencyTemplate() {
        return this.schemaProperties.getDependency().getTemplate();
    }

    @Override
    public boolean isAclEnabled() {
        return this.schemaProperties.getAcl().isEnabled();
    }

    @Override
    public Map<QualifiedName, Set<String>> getAcl() {
        return this.schemaProperties.getAcl().getAclMap();
    }

    @Override
    public StorageType getStorageType() {
        return this.schemaProperties.getStorage().getType();
    }

    @Override
    public String getStorageConfigPath() {
        return this.schemaProperties.getStorage().getConfigPath();
    }

    @Override
    public long getServiceRegionId() {
        return this.schemaProperties.getService().getRegionId();
    }

    @Override
    public long getServiceNodeId() {
        return this.schemaProperties.getService().getNodeId();
    }
}

