/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.rocketmq.schema.registry.common.dto.BaseDto;
import org.apache.rocketmq.schema.registry.common.model.Compatibility;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;

public class SchemaMetaDto
extends BaseDto {
    private static final long serialVersionUID = -4377140936300258473L;
    @ApiModelProperty(value="The type of the schema")
    private SchemaType type;
    @ApiModelProperty(value="The tenant of the schema")
    private String tenant;
    @ApiModelProperty(value="The namespace of the schema")
    private String namespace;
    @ApiModelProperty(value="The struct name of the schema")
    private String schemaName;
    @ApiModelProperty(value="Compatibility of the schema")
    private Compatibility compatibility;
    @ApiModelProperty(value="Owner of the schema")
    private String owner;
    @ApiModelProperty(value="The unique id of the schema")
    private long uniqueId;

    public static SchemaMetaDtoBuilder builder() {
        return new SchemaMetaDtoBuilder();
    }

    public SchemaType getType() {
        return this.type;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setUniqueId(long uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public String toString() {
        return "SchemaMetaDto(type=" + (Object)((Object)this.getType()) + ", tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", schemaName=" + this.getSchemaName() + ", compatibility=" + (Object)((Object)this.getCompatibility()) + ", owner=" + this.getOwner() + ", uniqueId=" + this.getUniqueId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaMetaDto)) {
            return false;
        }
        SchemaMetaDto other = (SchemaMetaDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUniqueId() != other.getUniqueId()) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        Compatibility this$compatibility = this.getCompatibility();
        Compatibility other$compatibility = other.getCompatibility();
        if (this$compatibility == null ? other$compatibility != null : !((Object)((Object)this$compatibility)).equals((Object)other$compatibility)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaMetaDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uniqueId = this.getUniqueId();
        result = result * 59 + (int)($uniqueId >>> 32 ^ $uniqueId);
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        Compatibility $compatibility = this.getCompatibility();
        result = result * 59 + ($compatibility == null ? 43 : ((Object)((Object)$compatibility)).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    public SchemaMetaDto(SchemaType type, String tenant, String namespace, String schemaName, Compatibility compatibility, String owner, long uniqueId) {
        this.type = type;
        this.tenant = tenant;
        this.namespace = namespace;
        this.schemaName = schemaName;
        this.compatibility = compatibility;
        this.owner = owner;
        this.uniqueId = uniqueId;
    }

    public SchemaMetaDto() {
    }

    public static class SchemaMetaDtoBuilder {
        private SchemaType type;
        private String tenant;
        private String namespace;
        private String schemaName;
        private Compatibility compatibility;
        private String owner;
        private long uniqueId;

        SchemaMetaDtoBuilder() {
        }

        public SchemaMetaDtoBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public SchemaMetaDtoBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public SchemaMetaDtoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SchemaMetaDtoBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public SchemaMetaDtoBuilder compatibility(Compatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        public SchemaMetaDtoBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public SchemaMetaDtoBuilder uniqueId(long uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public SchemaMetaDto build() {
            return new SchemaMetaDto(this.type, this.tenant, this.namespace, this.schemaName, this.compatibility, this.owner, this.uniqueId);
        }

        public String toString() {
            return "SchemaMetaDto.SchemaMetaDtoBuilder(type=" + (Object)((Object)this.type) + ", tenant=" + this.tenant + ", namespace=" + this.namespace + ", schemaName=" + this.schemaName + ", compatibility=" + (Object)((Object)this.compatibility) + ", owner=" + this.owner + ", uniqueId=" + this.uniqueId + ")";
        }
    }
}

