/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.context;

import org.apache.rocketmq.schema.registry.common.context.RequestContext;

public class RequestContextManager {
    private static final ThreadLocal<RequestContext> CONTEXTS = new ThreadLocal();

    private RequestContextManager() {
    }

    public static void removeContext() {
        CONTEXTS.remove();
    }

    public static RequestContext getContext() {
        RequestContext result = CONTEXTS.get();
        if (result == null) {
            result = new RequestContext();
            RequestContextManager.putContext(result);
        }
        return result;
    }

    public static void putContext(RequestContext context) {
        CONTEXTS.set(context);
    }
}

