/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.rocketmq.schema.registry.common.model.SubjectInfo;

public class QualifiedName
implements Serializable {
    private static final long serialVersionUID = 2266514833942841209L;
    private String cluster;
    private String tenant;
    private String subject;
    private String schema;
    private Long version;

    public QualifiedName(@Nullable String cluster, @Nullable String tenant, @Nullable String subject, @Nullable String schema) {
        this.cluster = cluster;
        this.tenant = tenant;
        this.subject = subject;
        this.schema = schema;
    }

    public QualifiedName(@Nullable String cluster, @Nullable String tenant, @Nullable String subject, @Nullable String schema, @Nullable Long version) {
        this.cluster = cluster;
        this.tenant = tenant;
        this.subject = subject;
        this.schema = schema;
        this.version = version;
    }

    public SubjectInfo subjectInfo() {
        return new SubjectInfo(this.cluster, this.tenant, this.subject);
    }

    public String fullName() {
        return this.cluster + '/' + this.tenant + '/' + this.subject + '/' + this.schema;
    }

    public String schemaFullName() {
        return this.tenant + '/' + this.schema;
    }

    public String subjectFullName() {
        return this.cluster + '/' + this.tenant + '/' + this.subject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append("cluster=").append(this.cluster).append(", ");
        sb.append("tenant=").append(this.tenant).append(", ");
        sb.append("subject=").append(this.subject).append(", ");
        sb.append("name=").append(this.schema).append(", ");
        sb.append("version=").append(this.version).append(")");
        return sb.toString();
    }

    public static QualifiedNameBuilder builder() {
        return new QualifiedNameBuilder();
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSchema() {
        return this.schema;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName other = (QualifiedName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QualifiedName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    public QualifiedName() {
    }

    public static class QualifiedNameBuilder {
        private String cluster;
        private String tenant;
        private String subject;
        private String schema;
        private Long version;

        QualifiedNameBuilder() {
        }

        public QualifiedNameBuilder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public QualifiedNameBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public QualifiedNameBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public QualifiedNameBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public QualifiedNameBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public QualifiedName build() {
            return new QualifiedName(this.cluster, this.tenant, this.subject, this.schema, this.version);
        }

        public String toString() {
            return "QualifiedName.QualifiedNameBuilder(cluster=" + this.cluster + ", tenant=" + this.tenant + ", subject=" + this.subject + ", schema=" + this.schema + ", version=" + this.version + ")";
        }
    }
}

