/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.config.JsonSerdeConfig;
import org.apache.rocketmq.schema.registry.client.exceptions.RestClientException;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.rest.JacksonMapper;
import org.apache.rocketmq.schema.registry.client.serde.Serializer;
import org.apache.rocketmq.schema.registry.common.dto.GetSchemaResponse;

public class JsonSerializer<T>
implements Serializer<T> {
    private SchemaRegistryClient registryClient;
    private final ObjectMapper objectMapper = JacksonMapper.INSTANCE;
    private boolean skipSchemaRegistry;

    public JsonSerializer() {
    }

    public JsonSerializer(SchemaRegistryClient registryClient) {
        this.registryClient = registryClient;
    }

    @Override
    public void configure(Map<String, Object> configs) {
        JsonSerdeConfig jsonSerdeConfig = new JsonSerdeConfig(configs);
        this.skipSchemaRegistry = jsonSerdeConfig.skipSchemaRegistry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(String subject, T originMessage) {
        if (null == originMessage) {
            return null;
        }
        if (this.skipSchemaRegistry) {
            try {
                return this.objectMapper.writeValueAsBytes(originMessage);
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("JSON serialize failed", e);
            }
        }
        if (null == this.registryClient) {
            throw new SerializationException("please initialize the schema registry client first");
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] bytes;
            GetSchemaResponse response = this.registryClient.getSchemaBySubject(subject);
            long schemaRecordId = response.getRecordId();
            ByteBuffer buffer = ByteBuffer.allocate(8);
            out.write(buffer.putLong(schemaRecordId).array());
            out.write(this.objectMapper.writeValueAsBytes(originMessage));
            byte[] byArray = bytes = out.toByteArray();
            return byArray;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("JSON serialize failed", e);
        }
        catch (RestClientException e) {
            throw new SerializationException("get schema by subject failed", e);
        }
    }

    @Override
    public void close() {
    }
}

