/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.config.AvroSerdeConfig;
import org.apache.rocketmq.schema.registry.client.exceptions.RestClientException;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.serde.Deserializer;
import org.apache.rocketmq.schema.registry.common.dto.GetSchemaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroDeserializer<T>
implements Deserializer<T> {
    Logger log = LoggerFactory.getLogger(AvroDeserializer.class);
    protected SchemaRegistryClient schemaRegistry;
    private boolean useGenericReader;
    private boolean useTargetVersionSchema;
    private long schemaTargetVersion;

    public AvroDeserializer() {
    }

    public AvroDeserializer(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistry = schemaRegistryClient;
    }

    @Override
    public void configure(Map<String, Object> configs) {
        AvroSerdeConfig config = new AvroSerdeConfig(configs);
        this.useGenericReader = config.useGenericReader();
        this.useTargetVersionSchema = config.useTargetVersionSchema();
        this.schemaTargetVersion = config.schemaTargetVersion();
    }

    @Override
    public T deserialize(String subject, byte[] payload) {
        return this.deserialize(subject, payload, null);
    }

    public T deserialize(String subject, byte[] payload, Schema readerSchema) throws SerializationException {
        if (this.schemaRegistry == null) {
            throw new SerializationException("please initialize the schema registry client first");
        }
        if (payload == null) {
            return null;
        }
        try {
            GetSchemaResponse response;
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)bais, null);
            if (this.useTargetVersionSchema) {
                response = -1L == this.schemaTargetVersion ? this.schemaRegistry.getSchemaBySubject(subject) : this.schemaRegistry.getSchemaBySubjectAndVersion(subject, this.schemaTargetVersion);
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(16);
                decoder.readBytes(buffer);
                long schemaRecordId = buffer.getLong();
                response = this.schemaRegistry.getSchemaByRecordId(subject, schemaRecordId);
            }
            Schema writerSchema = new Schema.Parser().parse(response.getIdl());
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            DatumReader<T> datumReader = this.getDatumReader(writerSchema, readerSchema);
            return (T)datumReader.read(null, (Decoder)decoder);
        }
        catch (RestClientException e) {
            this.log.warn("get schema by record id failed, maybe the schema storage service not available now", (Throwable)e);
            throw new SerializationException("get schema by record id failed, maybe the schema storage service not available now", e);
        }
        catch (IOException e) {
            this.log.warn("deserialize failed", (Throwable)e);
            throw new SerializationException("deserialize error", e);
        }
    }

    private Schema getReaderSchema(Schema writerSchema) {
        if (this.useGenericReader) {
            return writerSchema;
        }
        Class readerClass = SpecificData.get().getClass(writerSchema);
        if (readerClass == null) {
            throw new SerializationException("cannot get a schema for a SpecificRecord");
        }
        try {
            return ((SpecificRecord)readerClass.newInstance()).getSchema();
        }
        catch (InstantiationException e) {
            throw new SerializationException("cannot initialize reader schema by writerSchema class", e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("not allowed initialize reader schema by writerSchema class", e);
        }
    }

    private DatumReader<T> getDatumReader(Schema schema, Schema readerSchema) {
        if (this.useGenericReader) {
            return new GenericDatumReader(schema, readerSchema);
        }
        return new SpecificDatumReader(schema, readerSchema);
    }

    @Override
    public void close() {
    }
}

