/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class VerifyUtils {
    private static Logger logger = LoggerFactory.getLogger(VerifyUtils.class);

    public static int verify(Collection<Object> sendMsgs, Collection<Object> recvMsgs) {
        int miss = 0;
        for (Object msg : sendMsgs) {
            if (recvMsgs.contains(msg)) continue;
            ++miss;
        }
        return miss;
    }

    public static Collection<Object> getFilterdMessage(Collection<Object> sendMsgs, Collection<Object> recvMsgs) {
        Collection<Object> recvMsgsSync = Collections.synchronizedCollection(recvMsgs);
        ArrayList<Object> filteredMsgs = new ArrayList<Object>();
        int filterNum = 0;
        for (Object msg : recvMsgsSync) {
            if (sendMsgs.contains(msg)) {
                filteredMsgs.add(msg);
                continue;
            }
            ++filterNum;
        }
        logger.info(String.format("[%s] messages is filtered!", filterNum));
        return filteredMsgs;
    }

    public static int verifyUserProperty(Collection<Object> sendMsgs, Collection<Object> recvMsgs) {
        return 0;
    }

    public static void verifyMessageQueueId(int expectId, Collection<Object> msgs) {
        for (Object msg : msgs) {
            MessageExt msgEx = (MessageExt)msg;
            assert (expectId == msgEx.getQueueId());
        }
    }

    public static boolean verifyBalance(int msgSize, float error, int ... recvSize) {
        boolean balance = true;
        int evenSize = msgSize / recvSize.length;
        for (int size : recvSize) {
            if (!((float)Math.abs(size - evenSize) > error * (float)evenSize)) continue;
            balance = false;
            break;
        }
        return balance;
    }

    public static boolean verifyBalance(int msgSize, int ... recvSize) {
        return VerifyUtils.verifyBalance(msgSize, 0.1f, recvSize);
    }

    public static boolean verifyDelay(long delayTimeMills, long nextLevelDelayTimeMills, Collection<Object> recvMsgTimes) {
        boolean delay = true;
        for (Object timeObj : recvMsgTimes) {
            long time = (Long)timeObj;
            if (time >= delayTimeMills && time <= nextLevelDelayTimeMills) continue;
            delay = false;
            logger.info(String.format("delay error:%s", Math.abs(time - delayTimeMills)));
            break;
        }
        return delay;
    }

    public static boolean verifyOrder(Collection<Collection<Object>> queueMsgs) {
        for (Collection<Object> msgs : queueMsgs) {
            if (VerifyUtils.verifyOrderMsg(msgs)) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyOrderMsg(Collection<Object> msgs) {
        int min = Integer.MIN_VALUE;
        if (msgs.size() == 0 || msgs.size() == 1) {
            return true;
        }
        for (Object msg : msgs) {
            int curr = Integer.parseInt((String)msg);
            if (curr < min) {
                return false;
            }
            min = curr;
        }
        return true;
    }

    public static boolean verifyRT(Collection<Object> rts, long maxRTMills) {
        boolean rtExpect = true;
        for (Object obj : rts) {
            long rt = (Long)obj;
            if (rt <= maxRTMills) continue;
            rtExpect = false;
            logger.info(String.format("%s greater thran maxtRT:%s!", rt, maxRTMills));
        }
        return rtExpect;
    }

    public static void main(String[] args) {
        VerifyUtils.verifyBalance(400, 0.1f, 230, 190);
    }
}

