/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;

public final class RandomUtil {
    private static final int UNICODE_START = 19968;
    private static final int UNICODE_END = 40864;
    private static Random rd = new Random();

    private RandomUtil() {
    }

    public static long getLong() {
        return rd.nextLong();
    }

    public static long getLongMoreThanZero() {
        long res = rd.nextLong();
        while (res <= 0L) {
            res = rd.nextLong();
        }
        return res;
    }

    public static long getLongLessThan(long n) {
        long res = rd.nextLong();
        return res % n;
    }

    public static long getLongMoreThanZeroLessThan(long n) {
        long res = RandomUtil.getLongLessThan(n);
        while (res <= 0L) {
            res = RandomUtil.getLongLessThan(n);
        }
        return res;
    }

    public static long getLongBetween(long n, long m) {
        if (m <= n) {
            return n;
        }
        long res = RandomUtil.getLongMoreThanZero();
        return n + res % (m - n);
    }

    public static int getInteger() {
        return rd.nextInt();
    }

    public static int getIntegerMoreThanZero() {
        int res = rd.nextInt();
        while (res <= 0) {
            res = rd.nextInt();
        }
        return res;
    }

    public static int getIntegerLessThan(int n) {
        int res = rd.nextInt();
        return res % n;
    }

    public static int getIntegerMoreThanZeroLessThan(int n) {
        int res = rd.nextInt(n);
        while (res == 0) {
            res = rd.nextInt(n);
        }
        return res;
    }

    public static int getIntegerBetween(int n, int m) {
        if (m == n) {
            return n;
        }
        int res = RandomUtil.getIntegerMoreThanZero();
        return n + res % (m - n);
    }

    private static char getChar(int[] arg) {
        int size = arg.length;
        int c = rd.nextInt(size / 2);
        return (char)RandomUtil.getIntegerBetween(arg[c *= 2], arg[c + 1]);
    }

    private static String getString(int n, int[] arg) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            res.append(RandomUtil.getChar(arg));
        }
        return res.toString();
    }

    public static String getStringWithCharacter(int n) {
        int[] arg = new int[]{97, 123, 65, 91};
        return RandomUtil.getString(n, arg);
    }

    public static String getStringWithNumber(int n) {
        int[] arg = new int[]{48, 58};
        return RandomUtil.getString(n, arg);
    }

    public static String getStringWithNumAndCha(int n) {
        int[] arg = new int[]{97, 123, 65, 91, 48, 58};
        return RandomUtil.getString(n, arg);
    }

    public static String getStringShortenThan(int n) {
        int len = RandomUtil.getIntegerMoreThanZeroLessThan(n);
        return RandomUtil.getStringWithCharacter(len);
    }

    public static String getStringWithNumAndChaShortenThan(int n) {
        int len = RandomUtil.getIntegerMoreThanZeroLessThan(n);
        return RandomUtil.getStringWithNumAndCha(len);
    }

    public static String getStringBetween(int n, int m) {
        int len = RandomUtil.getIntegerBetween(n, m);
        return RandomUtil.getStringWithCharacter(len);
    }

    public static String getStringWithNumAndChaBetween(int n, int m) {
        int len = RandomUtil.getIntegerBetween(n, m);
        return RandomUtil.getStringWithNumAndCha(len);
    }

    public static String getStringWithPrefix(int n, String prefix) {
        int len = prefix.length();
        if (n <= len) {
            return prefix;
        }
        len = n - len;
        StringBuilder res = new StringBuilder(prefix);
        res.append(RandomUtil.getStringWithCharacter(len));
        return res.toString();
    }

    public static String getStringWithSuffix(int n, String suffix) {
        int len = suffix.length();
        if (n <= len) {
            return suffix;
        }
        len = n - len;
        StringBuilder res = new StringBuilder();
        res.append(RandomUtil.getStringWithCharacter(len));
        res.append(suffix);
        return res.toString();
    }

    public static String getStringWithBoth(int n, String prefix, String suffix) {
        int len = prefix.length() + suffix.length();
        StringBuilder res = new StringBuilder(prefix);
        if (n <= len) {
            return res.append(suffix).toString();
        }
        len = n - len;
        res.append(RandomUtil.getStringWithCharacter(len));
        res.append(suffix);
        return res.toString();
    }

    public static String getCheseWordWithPrifix(int n, String prefix) {
        int len = prefix.length();
        if (n <= len) {
            return prefix;
        }
        len = n - len;
        StringBuilder res = new StringBuilder(prefix);
        res.append(RandomUtil.getCheseWord(len));
        return res.toString();
    }

    public static String getCheseWordWithSuffix(int n, String suffix) {
        int len = suffix.length();
        if (n <= len) {
            return suffix;
        }
        len = n - len;
        StringBuilder res = new StringBuilder();
        res.append(RandomUtil.getCheseWord(len));
        res.append(suffix);
        return res.toString();
    }

    public static String getCheseWordWithBoth(int n, String prefix, String suffix) {
        int len = prefix.length() + suffix.length();
        StringBuilder res = new StringBuilder(prefix);
        if (n <= len) {
            return res.append(suffix).toString();
        }
        len = n - len;
        res.append(RandomUtil.getCheseWord(len));
        res.append(suffix);
        return res.toString();
    }

    public static String getCheseWord(int len) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char str = RandomUtil.getCheseChar();
            res.append(str);
        }
        return res.toString();
    }

    private static char getCheseChar() {
        return (char)(19968 + rd.nextInt(20896));
    }

    public static boolean getBoolean() {
        return RandomUtil.getIntegerMoreThanZeroLessThan(3) == 1;
    }

    public static String getStringByUUID() {
        return UUID.randomUUID().toString();
    }

    public static int[] getRandomArray(int min, int max, int n) {
        int len = max - min + 1;
        if (max < min || n > len) {
            return null;
        }
        int[] source = new int[len];
        for (int i = min; i < min + len; ++i) {
            source[i - min] = i;
        }
        int[] result = new int[n];
        Random rd = new Random();
        int index = 0;
        for (int i = 0; i < result.length; ++i) {
            index = rd.nextInt(len--);
            result[i] = source[index];
            source[index] = source[len];
        }
        return result;
    }

    public static Collection<Integer> getRandomCollection(int min, int max, int n) {
        HashSet<Integer> res = new HashSet<Integer>();
        int mx = max;
        int mn = min;
        if (n == max + 1 - min) {
            for (int i = 1; i <= n; ++i) {
                res.add(i);
            }
            return res;
        }
        for (int i = 0; i < n; ++i) {
            int v = RandomUtil.getIntegerBetween(mn, mx);
            if (v == mx) {
                --mx;
            }
            if (v == mn) {
                ++mn;
            }
            while (res.contains(v)) {
                v = RandomUtil.getIntegerBetween(mn, mx);
                if (v == mx) {
                    mx = v;
                }
                if (v != mn) continue;
                mn = v;
            }
            res.add(v);
        }
        return res;
    }
}

