/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingOne;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicRemappingDetailWrapper;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.rpc.ClientMetadata;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminUtils;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.topic.RemappingStaticTopicSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateStaticTopicSubCommand;
import org.awaitility.Awaitility;

public class MQAdminTestUtils {
    private static Logger log = LoggerFactory.getLogger(MQAdminTestUtils.class);
    private static DefaultMQAdminExt mqAdminExt;

    public static void startAdmin(String nameSrvAddr) throws MQClientException {
        mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        mqAdminExt.start();
    }

    public static void shutdownAdmin() {
        mqAdminExt.shutdown();
    }

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum, Map<String, String> attributes) {
        int defaultWaitTime = 30;
        return MQAdminTestUtils.createTopic(nameSrvAddr, clusterName, topic, queueNum, attributes, defaultWaitTime);
    }

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum, Map<String, String> attributes, int waitTimeSec) {
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setInstanceName(UUID.randomUUID().toString());
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        try {
            mqAdminExt.start();
            mqAdminExt.createTopic(clusterName, topic, queueNum, attributes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Awaitility.await().atMost((long)waitTimeSec, TimeUnit.SECONDS).until(() -> MQAdminTestUtils.checkTopicExist(mqAdminExt, topic));
        ForkJoinPool.commonPool().execute(() -> ((DefaultMQAdminExt)mqAdminExt).shutdown());
        return true;
    }

    public static boolean checkTopicExist(DefaultMQAdminExt mqAdminExt, String topic) {
        boolean createResult = false;
        try {
            TopicStatsTable topicInfo = mqAdminExt.examineTopicStats(topic);
            createResult = !topicInfo.getOffsetTable().isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return createResult;
    }

    public static boolean createSub(String nameSrvAddr, String clusterName, String consumerId) {
        boolean createResult = true;
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        SubscriptionGroupConfig config = new SubscriptionGroupConfig();
        config.setGroupName(consumerId);
        try {
            mqAdminExt.start();
            Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)mqAdminExt, (String)clusterName);
            for (String addr : masterSet) {
                try {
                    mqAdminExt.createAndUpdateSubscriptionGroupConfig(addr, config);
                    log.info(String.format("create subscription group %s to %s success.\n", consumerId, addr));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            createResult = false;
            e.printStackTrace();
        }
        ForkJoinPool.commonPool().execute(() -> ((DefaultMQAdminExt)mqAdminExt).shutdown());
        return createResult;
    }

    public static ClusterInfo getCluster(String nameSrvAddr) {
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        ClusterInfo clusterInfo = null;
        try {
            mqAdminExt.start();
            clusterInfo = mqAdminExt.examineBrokerClusterInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ForkJoinPool.commonPool().execute(() -> ((DefaultMQAdminExt)mqAdminExt).shutdown());
        return clusterInfo;
    }

    public static boolean isBrokerExist(String ns, String ip) {
        ClusterInfo clusterInfo = MQAdminTestUtils.getCluster(ns);
        if (clusterInfo == null) {
            return false;
        }
        Map brokers = clusterInfo.getBrokerAddrTable();
        for (String brokerName : brokers.keySet()) {
            HashMap brokerIps = ((BrokerData)brokers.get(brokerName)).getBrokerAddrs();
            Iterator iterator = brokerIps.keySet().iterator();
            while (iterator.hasNext()) {
                long brokerId = (Long)iterator.next();
                if (!((String)brokerIps.get(brokerId)).contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean awaitStaticTopicMs(long timeMs, String topic, DefaultMQAdminExt defaultMQAdminExt, MQClientInstance clientInstance) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= timeMs) {
            if (MQAdminTestUtils.checkStaticTopic(topic, defaultMQAdminExt, clientInstance)) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public static boolean checkStaticTopic(String topic, DefaultMQAdminExt defaultMQAdminExt, MQClientInstance clientInstance) throws Exception {
        Map brokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)defaultMQAdminExt);
        assert (!brokerConfigMap.isEmpty());
        TopicQueueMappingUtils.checkPhysicalQueueConsistence((Map)brokerConfigMap);
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)brokerConfigMap);
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems((List)TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), (boolean)false, (boolean)true);
        for (int i = 0; i < globalIdMap.size(); ++i) {
            TopicQueueMappingOne mappingOne = (TopicQueueMappingOne)globalIdMap.get(i);
            String mockBrokerName = TopicQueueMappingUtils.getMockBrokerName((String)mappingOne.getMappingDetail().getScope());
            String bnameFromRoute = clientInstance.getBrokerNameFromMessageQueue(new MessageQueue(topic, mockBrokerName, mappingOne.getGlobalId().intValue()));
            if (mappingOne.getBname().equals(bnameFromRoute)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, TopicConfigAndQueueMapping> createStaticTopic(String topic, int queueNum, Set<String> targetBrokers, DefaultMQAdminExt defaultMQAdminExt) throws Exception {
        Map brokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)defaultMQAdminExt);
        assert (brokerConfigMap.isEmpty());
        TopicQueueMappingUtils.createTopicConfigMapping((String)topic, (int)queueNum, targetBrokers, (Map)brokerConfigMap);
        MQAdminUtils.completeNoTargetBrokers((Map)brokerConfigMap, (DefaultMQAdminExt)defaultMQAdminExt);
        MQAdminUtils.updateTopicConfigMappingAll((Map)brokerConfigMap, (DefaultMQAdminExt)defaultMQAdminExt, (boolean)false);
        return brokerConfigMap;
    }

    public static void remappingStaticTopic(String topic, Set<String> targetBrokers, DefaultMQAdminExt defaultMQAdminExt) throws Exception {
        Map brokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)defaultMQAdminExt);
        assert (!brokerConfigMap.isEmpty());
        TopicRemappingDetailWrapper wrapper = TopicQueueMappingUtils.remappingStaticTopic((String)topic, (Map)brokerConfigMap, targetBrokers);
        MQAdminUtils.completeNoTargetBrokers((Map)brokerConfigMap, (DefaultMQAdminExt)defaultMQAdminExt);
        MQAdminUtils.remappingStaticTopic((String)topic, (Set)wrapper.getBrokerToMapIn(), (Set)wrapper.getBrokerToMapOut(), (Map)brokerConfigMap, (int)10000, (boolean)false, (DefaultMQAdminExt)defaultMQAdminExt);
    }

    public static void remappingStaticTopicWithNegativeLogicOffset(String topic, Set<String> targetBrokers, DefaultMQAdminExt defaultMQAdminExt) throws Exception {
        Map brokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)defaultMQAdminExt);
        assert (!brokerConfigMap.isEmpty());
        TopicRemappingDetailWrapper wrapper = TopicQueueMappingUtils.remappingStaticTopic((String)topic, (Map)brokerConfigMap, targetBrokers);
        MQAdminUtils.completeNoTargetBrokers((Map)brokerConfigMap, (DefaultMQAdminExt)defaultMQAdminExt);
        MQAdminTestUtils.remappingStaticTopicWithNegativeLogicOffset(topic, wrapper.getBrokerToMapIn(), wrapper.getBrokerToMapOut(), brokerConfigMap, 10000, false, defaultMQAdminExt);
    }

    public static void remappingStaticTopicWithNegativeLogicOffset(String topic, Set<String> brokersToMapIn, Set<String> brokersToMapOut, Map<String, TopicConfigAndQueueMapping> brokerConfigMap, int blockSeqSize, boolean force, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicConfigAndQueueMapping configMapping;
        String addr;
        ClientMetadata clientMetadata = MQAdminUtils.getBrokerMetadata((DefaultMQAdminExt)defaultMQAdminExt);
        MQAdminUtils.checkIfMasterAlive(brokerConfigMap.keySet(), (DefaultMQAdminExt)defaultMQAdminExt, (ClientMetadata)clientMetadata);
        for (String broker : brokersToMapIn) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
        for (String broker : brokersToMapOut) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
        for (String broker : brokerConfigMap.keySet()) {
            if (brokersToMapIn.contains(broker) || brokersToMapOut.contains(broker)) continue;
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
    }

    public static void createStaticTopicWithCommand(String topic, int queueNum, Set<String> brokers, String cluster, String nameservers) throws Exception {
        String[] args;
        UpdateStaticTopicSubCommand cmd = new UpdateStaticTopicSubCommand();
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        if (cluster != null) {
            args = new String[]{"-c", cluster, "-t", topic, "-qn", String.valueOf(queueNum), "-n", nameservers};
        } else {
            String brokerStr = String.join((CharSequence)",", brokers);
            args = new String[]{"-b", brokerStr, "-t", topic, "-qn", String.valueOf(queueNum), "-n", nameservers};
        }
        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])args, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            return;
        }
        if (commandLine.hasOption('n')) {
            String namesrvAddr = commandLine.getOptionValue('n');
            System.setProperty("rocketmq.namesrv.addr", namesrvAddr);
        }
        cmd.execute(commandLine, options, null);
    }

    public static void remappingStaticTopicWithCommand(String topic, Set<String> brokers, String cluster, String nameservers) throws Exception {
        String[] args;
        RemappingStaticTopicSubCommand cmd = new RemappingStaticTopicSubCommand();
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        if (cluster != null) {
            args = new String[]{"-c", cluster, "-t", topic, "-n", nameservers};
        } else {
            String brokerStr = String.join((CharSequence)",", brokers);
            args = new String[]{"-b", brokerStr, "-t", topic, "-n", nameservers};
        }
        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])args, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            return;
        }
        if (commandLine.hasOption('n')) {
            String namesrvAddr = commandLine.getOptionValue('n');
            System.setProperty("rocketmq.namesrv.addr", namesrvAddr);
        }
        cmd.execute(commandLine, options, null);
    }

    public static ConsumeStats examineConsumeStats(String brokerAddr, String topic, String group) {
        ConsumeStats consumeStats = null;
        try {
            consumeStats = mqAdminExt.examineConsumeStats(brokerAddr, group, topic, 3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return consumeStats;
    }
}

