/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public class FileUtil {
    private static String lineSeparator = System.getProperty("line.separator");
    private String filePath = "";
    private String fileName = "";

    public FileUtil(String filePath, String fileName) {
        this.filePath = filePath;
        this.fileName = fileName;
    }

    public static void main(String[] args) {
        String filePath = FileUtil.class.getResource("/").getPath();
        String fileName = "test.txt";
        FileUtil fileUtil = new FileUtil(filePath, fileName);
        Properties properties = new Properties();
        properties.put("xx", "yy");
        properties.put("yy", "xx");
        fileUtil.writeProperties(properties);
    }

    public void deleteFile() {
        File file = new File(this.filePath + File.separator + this.fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public void appendFile(String content) {
        File file = this.openFile();
        String newContent = lineSeparator + content;
        this.writeFile(file, newContent, true);
    }

    public void coverFile(String content) {
        File file = this.openFile();
        this.writeFile(file, content, false);
    }

    public void writeProperties(Properties properties) {
        String content = this.getPropertiesAsString(properties);
        this.coverFile(content);
    }

    private String getPropertiesAsString(Properties properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> keyEnty : properties.entrySet()) {
            sb.append(keyEnty.getKey()).append("=").append((String)keyEnty.getValue()).append(lineSeparator);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content, boolean append) {
        Writer writer = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(file, append);
            writer = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File openFile() {
        File file = new File(this.filePath + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }
}

