/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.rocketmq.test.schema.SchemaDefiner;

public class SchemaTools {
    public static final String PATH_API = "api";
    public static final String PATH_PROTOCOL = "protocol";

    public static String isPublicOrPrivate(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return "public";
        }
        if (Modifier.isProtected(modifiers)) {
            return "protected";
        }
        return "private";
    }

    public static TreeMap<String, String> buildSchemaOfFields(Class apiClass) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class current = apiClass;
        do {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        Object obj = null;
        if (!(apiClass.isInterface() || Modifier.isAbstract(apiClass.getModifiers()) || apiClass.isEnum())) {
            Object constructor = null;
            for (Constructor<?> tmp : apiClass.getConstructors()) {
                if (constructor == null) {
                    constructor = tmp;
                }
                if (tmp.getParameterCount() >= ((Constructor)constructor).getParameterCount()) continue;
                constructor = tmp;
            }
            assert (constructor != null);
            ((Constructor)constructor).setAccessible(true);
            String msg = ((Constructor)constructor).getName();
            try {
                obj = ((Constructor)constructor).newInstance(Arrays.stream(((Constructor)constructor).getParameterTypes()).map(x -> {
                    try {
                        if (x.isEnum()) {
                            return x.getEnumConstants()[0];
                        }
                        if (x == Boolean.TYPE) {
                            return false;
                        }
                        if (x == Character.TYPE) {
                            return "";
                        }
                        if (x.isPrimitive()) {
                            return 0;
                        }
                        return x.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        return x.cast(null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(msg + " " + x.getName(), e);
                    }
                }).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(msg, e);
            }
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (apiClass.isEnum()) {
            for (Object enumObject : apiClass.getEnumConstants()) {
                String name = ((Enum)enumObject).name();
                int n = ((Enum)enumObject).ordinal();
                String key = String.format("Field %s", name);
                String value = String.format("%s %s %s", "public", "int", "" + n);
                map.put(key, value);
            }
            return map;
        }
        for (Field field : fields) {
            if (field.getName().startsWith("$")) continue;
            String key = String.format("Field %s", field.getName());
            boolean ignore = false;
            for (Class clazz : SchemaDefiner.IGNORED_FIELDS.keySet()) {
                if (!clazz.isAssignableFrom(apiClass) || !SchemaDefiner.IGNORED_FIELDS.get(clazz).contains(field.getName())) continue;
                ignore = true;
                break;
            }
            if (!(field.getType().isEnum() || field.getType().isPrimitive() || SchemaDefiner.FIELD_CLASS_NAMES.contains(field.getType().getName()))) {
                ignore = true;
            }
            field.setAccessible(true);
            Object fieldValue = "null";
            try {
                fieldValue = field.get(obj);
            }
            catch (Exception exception) {
                throw new RuntimeException(apiClass.getName() + " " + field.getName(), exception);
            }
            if (ignore) {
                fieldValue = "null";
            }
            String string = String.format("%s %s %s", SchemaTools.isPublicOrPrivate(field.getModifiers()), field.getType().getName(), fieldValue);
            map.put(key, string);
        }
        return map;
    }

    public static TreeMap<String, String> buildSchemaOfMethods(Class apiClass) throws Exception {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class current = apiClass;
        do {
            methods.addAll(Arrays.asList(current.getDeclaredMethods()));
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (apiClass.isEnum()) {
            return map;
        }
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Arrays.sort(parameterTypes, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            Arrays.sort(exceptionTypes, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            String key = String.format("Method %s(%s)", method.getName(), Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(",")));
            String value = String.format("%s throws (%s): %s", SchemaTools.isPublicOrPrivate(method.getModifiers()), method.getReturnType().getName(), Arrays.stream(exceptionTypes).map(Class::getName).collect(Collectors.joining(",")));
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, TreeMap<String, String>> generate(List<Class<?>> classList) throws Exception {
        HashMap<String, TreeMap<String, String>> schemaMap = new HashMap<String, TreeMap<String, String>>();
        for (Class<?> apiClass : classList) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.putAll(SchemaTools.buildSchemaOfFields(apiClass));
            map.putAll(SchemaTools.buildSchemaOfMethods(apiClass));
            schemaMap.put(apiClass.getName().replace("org.apache.rocketmq.", ""), map);
        }
        return schemaMap;
    }

    public static void write(Map<String, TreeMap<String, String>> schemaMap, String base, String label) throws Exception {
        for (Map.Entry<String, TreeMap<String, String>> entry : schemaMap.entrySet()) {
            TreeMap<String, String> map = entry.getValue();
            String fileName = String.format("%s/%s/%s.schema", base, label, entry.getKey());
            File file = new File(fileName);
            FileOutputStream fileStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
            writer.write("/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
            for (Map.Entry<String, String> kv : map.entrySet()) {
                ((Writer)writer).append(String.format("%s : %s\n", kv.getKey(), kv.getValue()));
            }
            ((Writer)writer).close();
        }
    }

    public static Map<String, TreeMap<String, String>> load(String base, String label) throws Exception {
        File dir = new File(String.format("%s/%s", base, label));
        TreeMap<String, TreeMap<String, String>> schemaMap = new TreeMap<String, TreeMap<String, String>>();
        for (File file : dir.listFiles()) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            String line = null;
            TreeMap<String, String> kvs = new TreeMap<String, String>();
            while ((line = br.readLine()) != null) {
                if (line.contains("*") || line.trim().isEmpty()) continue;
                String[] items = line.split(":");
                kvs.put(items[0].trim(), items[1].trim());
            }
            br.close();
            schemaMap.put(file.getName().replace(".schema", ""), kvs);
        }
        return schemaMap;
    }
}

