/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.listener.rmq.order;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.listener.AbstractListener;

public class RMQOrderListener
extends AbstractListener
implements MessageListenerOrderly {
    private Map<String, Collection<Object>> msgs = new ConcurrentHashMap<String, Collection<Object>>();

    public RMQOrderListener() {
    }

    public RMQOrderListener(String listnerName) {
        super(listnerName);
    }

    public RMQOrderListener(String originMsgCollector, String msgBodyCollector) {
        super(originMsgCollector, msgBodyCollector);
    }

    public Collection<Collection<Object>> getMsgs() {
        return this.msgs.values();
    }

    private void putMsg(MessageExt msg) {
        Collection<Object> msgQueue = null;
        String key = this.getKey(msg.getQueueId(), msg.getStoreHost().toString());
        msgQueue = !this.msgs.containsKey(key) ? new ArrayList<String>() : this.msgs.get(key);
        msgQueue.add(new String(msg.getBody(), StandardCharsets.UTF_8));
        this.msgs.put(key, msgQueue);
    }

    private String getKey(int queueId, String brokerIp) {
        return String.format("%s_%s", queueId, brokerIp);
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        for (MessageExt msg : msgs) {
            if (this.isDebug) {
                if (this.listenerName != null && this.listenerName != "") {
                    LOGGER.info(this.listenerName + ": " + msg);
                } else {
                    LOGGER.info("{}", (Object)msg);
                }
            }
            this.putMsg(msg);
            this.msgBodys.addData(new String(msg.getBody(), StandardCharsets.UTF_8));
            this.originMsgs.addData(msg);
        }
        return ConsumeOrderlyStatus.SUCCESS;
    }
}

