/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.listener.rmq.concurrent;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.util.RandomUtil;
import org.apache.rocketmq.test.util.data.collect.DataCollector;
import org.apache.rocketmq.test.util.data.collect.DataCollectorManager;

public class RMQDelayListener
extends AbstractListener
implements MessageListenerConcurrently {
    private DataCollector msgDelayTimes = DataCollectorManager.getInstance().fetchDataCollector(RandomUtil.getStringByUUID());

    public Collection<Object> getMsgDelayTimes() {
        return this.msgDelayTimes.getAllData();
    }

    public void resetMsgDelayTimes() {
        this.msgDelayTimes.resetData();
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        long recvTime = System.currentTimeMillis();
        for (MessageExt msg : msgs) {
            if (this.isDebug) {
                LOGGER.info(this.listenerName + ":" + msg);
            }
            this.msgBodys.addData(new String(msg.getBody(), StandardCharsets.UTF_8));
            this.originMsgs.addData(msg);
            this.msgDelayTimes.addData(Math.abs(recvTime - msg.getBornTimestamp()));
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }
}

